/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * \class DecisionConfig
 * \author Jeshua Bratman
 *
 * Finds, loads, and creates decision from shared libraries.
 */

#ifndef DECISIONCONFIG_H
#define DECISIONCONFIG_H

//std includes
#include <vector>
using namespace std;

#include "PluginLoader.hpp"
#include "Decision.hpp"
#include "Param.hpp"
#include "SessionManager.hpp"
using namespace CEBL;

//forward declarations
class CEBLModel;

class DecisionConfig
{
private:
  //make session manager a friend
  friend class SessionManager;

  CEBLModel *model;

  //decision plugins
  PluginLoader<Decision> * plugin_loader;
  PluginLoader<Decision> * getPluginLoader() { return plugin_loader; }


  //selected decision
  string selected_decision;

public:
  DecisionConfig(CEBLModel *);
  ~DecisionConfig();

  //GETTING OPERATIONS
  std::vector<string> getNameList();
  std::vector<string> getPathList();
  string getSelected();
  std::map<std::string, CEBL::Param> getParams(string decision = "");

  //SETTING OPERATIONS
  void setSelected(string decision = "");
  void setParams(std::map<std::string, CEBL::Param> list,string decision = "");

  //DECTION OPERATIONS
  void updateWithProbabilities(std::vector<std::vector<double> >probs);
  void updateWithProbabilities(std::vector<double> probs);
  void updateWithClassification(ublas::vector<int> classes);
  void updateWithClassification(int cls);
  void init(int num_classes);
  std::vector<double> decideClasses();
};

#endif

