#include <fstream>
#include <sstream>
using namespace std;


#include "../CEBLModel.hpp"
#include "DeviceConfig.hpp"
#include "Mindset24.hpp"


//----------------------------------------------------------------------
// Constructors / Destructors

DeviceConfig::DeviceConfig(CEBLModel *model)
{
  this->model = model;
  device_location = "/dev/eeg";
  device_connected = false;
  device_exists = false;
  device_writeable = false;
  error_text = "";
  inquiry_text = "";
  this->scanForDevices();
  this->isReady();

  this->sample_rate = 3;//we should read this from device
  this->block_size = 3;//we should read this from device
}

DeviceConfig::~DeviceConfig(){}



//----------------------------------------------------------------------
// Getting Operations

int DeviceConfig::getSampleRate()
{
  return this->sample_rate;
}

int DeviceConfig::getBlockSize()
{
  return this->block_size;
}



bool DeviceConfig::isReady()
{
  error_text = "";
  inquiry_text = "";
  ifstream read;
  ofstream write;

  device_connected = false;
  read.open(device_location.c_str(), ifstream::in);
  read.close();
  if(read.fail())
    {
      device_exists = false;
      device_writeable = false;
      device_connected = false;
      error_text = model->getString("DeviceError2");
      inquiry_text = "";
      return false;
    }
  else
    {
      device_exists = true;
      device_connected = false;
    }


  //check if device is writeable now
  if(device_exists)
    {
      write.open(device_location.c_str(), ios::app);
      write.close();
      if(write.fail())
        {
          device_writeable = false;
          device_connected = false;
          error_text = model->getString("DeviceError1");
          return false;
        }
      else
        {
          device_writeable = true;
          error_text = "";
        }

    }


  if(device_writeable)
    {
      try
        {
          Mindset24 mindset;
          mindset.Open(device_location.c_str());
          if(!mindset.IsOpen())
            {
              error_text = model->getString("DeviceError6");
            }
          else if(!mindset.IsMindset())
            {
              string rep = model->getString("DeviceError5");
              rep += mindset.Inquiry();
              error_text = rep;
            }
          else if(!mindset.Ready())
            {
              error_text = model->getString("DeviceError4");
            }
          else
            {
              device_connected = true;
            }
        }
      catch(...)
        {
          error_text = model->getString("DeviceError3");
          device_connected = false;
          return false;
        }
    }
  //change widget appearances based on information gathered
  if(device_connected)
    {
      string rep = model->getString("DeviceSuccess1");
      try
        {
          //creating mindset null
          Mindset24 mindset;
          mindset.Open(device_location.c_str());
          rep += mindset.Inquiry();
          mindset.Close();
        }catch(const char *m)
        {
          cout << m << "\n";
        }
      inquiry_text = rep;
    }

  return device_connected;
}

//----------------------------------------------------------------------
// Setting Operations


void DeviceConfig::setDeviceLocation(std::string location)
{
  device_location = location;
  this->isReady();
}

void DeviceConfig::setSampleRate(int sample_rate)
{
  this->sample_rate = sample_rate;
}

void DeviceConfig::setBlockSize(int block_size)
{
  this->block_size = block_size;
}

void DeviceConfig::scanForDevices()
{

  cout << "Searching for EEG Device...\n" << std::flush;
  ifstream read;
  ofstream write;
  bool device_writeable, device_exists;
  std::vector<string> device_labels;
  //add device labels to search for
  device_labels.push_back("eeg");
  //device_labels.push_back("eeg_amplifier");
  //device_labels.push_back("mindset");
  for(int i=0;i<9;i++)
    {
      stringstream dev;
      dev << "sg" << i;
      device_labels.push_back(dev.str());
    }

  //search through all device labels
  for(unsigned int i=0; i<device_labels.size(); i++)
    {
      stringstream dev;
      dev << "/dev/" << device_labels[i] ;
      read.open(dev.str().c_str(), ifstream::in);
      read.close();
      if(read.fail())
        {
          device_exists = false;
          device_writeable = false;
        }
      else
        device_exists = true;
      //check if device is writeable now
      if(device_exists)
        {
          write.open(dev.str().c_str(), ios::app);
          write.close();
          if(write.fail())
            device_writeable = false;
          else
            device_writeable = true;
        }
      //check if device is a mindset
      if(device_writeable)
        {
          Mindset24 mindset;
          mindset.Open(dev.str().c_str());
          if(mindset.IsOpen() && mindset.IsMindset() && mindset.Ready())
            {
              device_connected = true;
              device_location = dev.str();
              break;
            }
        }
    }
}
