/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! 
 * \class DeviceConfig
 * \author Jeshua Bratman
 *
 * Configuration for device tab.
 */


#ifndef DEVICECONFIG_H
#define DEVICECONFIG_H

//forward declarations
class CEBLModel;


class DeviceConfig
{
private:
  string device_location;
  bool device_connected;
  bool device_exists;
  bool device_writeable;

  CEBLModel * model;
  string error_text;
  string inquiry_text;

  int block_size;
  int sample_rate;

public:
  DeviceConfig(CEBLModel *);
  ~DeviceConfig();

  string getLocation() { return device_location; }
  bool isReady();
  string getError() { return error_text; }
  string getInquiry() { return inquiry_text; }
  bool exists() { return device_exists; }
  int getSampleRate();
  int getBlockSize();

  void setDeviceLocation(std::string location);
  void setSampleRate(int sample_rate);
  void setBlockSize(int block_size);
  void scanForDevices();
};


#endif
