/*! EEGDataStream.cpp
 * \author Jeshua Bratman
 *
 * Provides threaded buffer interface to a data source.
 */


#include "EEGDataStream.hpp"
#include "../Exceptions.hpp"
#include <cppR/cppR.hpp>



using namespace cppR;

//----------------------------------------------------------------------
// CONSTRUCTORS / DESTRUCTORS


EEGDataStream::EEGDataStream()
{
  setSampleRate(256);
  //timeout length in milliseconds
  timeout_length = 50;
}

EEGDataStream::~EEGDataStream()
{

}


//----------------------------------------------------------------------


EEGData EEGDataStream::read(int samples)
{
  if(getSamplesAvailable() < samples)
    {
      throw DataExceptionUnderflow("Fewer samples available than requested.");
    }

  if(samples==getSamplesAvailable())
    return readAll();
  EEGData ret;
  //lock the buffer
  {
    boost::mutex::scoped_lock lock(thread_lock);
    ublas::matrix<double> data = buffer;
    ret = EEGData(submatrix(data,0,0,0,samples));
    buffer = EEGData(submatrix(data,0,0,samples+1,data.size2()-1));
  }

  return ret;

}

EEGData EEGDataStream::readAll()
{
  EEGData ret;
  //lock the buffer
  {
    boost::mutex::scoped_lock lock(thread_lock);
    ret = buffer;
    buffer.clear();
  }

  return ret;
}

//----------------------------------------------------------------------
// THREAD

void EEGDataStream::start()
{
  if(!isStarted())
    {
      //clear data
      readAll();

      //run sublclass start method
      onStart();

      timeoutStart();

    }
}
void EEGDataStream::stop()
{
  if(isStarted())
    {
      // let the thread finish
      this->haltAndJoin();

      //clear data
      readAll();

      //run sublclass stop method
      try
        {
          onStop();
        }
      catch(...)
        {
          //don't worry about exception because we are stopping anyway
          cerr << "EEGDataStream: Exception caugh when stopping stream.";
        }
    }
}


void EEGDataStream::timeoutFunction()
{
  try
    {
      updater();
    }
  catch(exception& e)
    {
      halt = true;
      cerr << "Halted data stream due to exception: "  << e.what() << "\n";
    }
  catch(const char *m)
    {
      halt = true;
      cerr << "Halted data stream due to exception: "  << m << "\n";
    }
}
