/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! EEGDataStream.cpp
 * \author Jeshua Bratman
 *
 * Provides threaded buffer interface to a data source.
 */


#ifndef EEGDATASTREAM_H
#define EEGDATASTREAM_H

#include "../CEBLIncludes.hpp"
#include "EEGData.hpp"
#include <boost/thread/thread.hpp>
#include <boost/thread/mutex.hpp>
#include "TimeoutThread.hpp"

class EEGDataStream : public TimeoutThread
{
private:
  void timeoutFunction();

protected:
  EEGData buffer;
  //samples per second
  int sample_rate;
  //updater
  virtual void updater() = 0;
  virtual void onStart() {};
  virtual void onStop() {};

public:
  EEGDataStream();
  virtual ~EEGDataStream();

  void start();
  void stop();

  void setSampleRate(int sr) { sample_rate = sr; }

  bool isStarted() { return is_started; }
  int getSamplesAvailable() { return buffer.numSamples(); }
  //! read and remove n samples from the buffer
  EEGData read(int samples);
  //! read all samples from the buffer and clear the buffer
  EEGData readAll();
};



#endif
