/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! \class CEBL::Feature
 *  \author Jeshua Bratman
 *
 * Provides interface for feature plugins.
 *
 */

#ifndef FEATURE_H
#define FEATURE_H


#include <string>
#include <vector>

#include "../cppR/cppR.hpp"

#include "Plugin.hpp"
#include "EEGTrainingData.hpp"




namespace CEBL
{
  class Feature : public Plugin
  {
  protected:
    int sample_rate;

  public:
        virtual ~Feature(){};

    /*! Called when sample rate changes. 
      \param sample_rate 
    */
    void setSampleRate(int sample_rate) { this->sample_rate = sample_rate; };




    //-----------------------------------------------------------------
    //Function to override below

    /*! Use feature on data and return new matrix. 
      
      \return 
    */
    virtual ublas::matrix<double> use(const ublas::matrix<double> &) = 0;

    /*! Called every time a class is selected. 
     */
    virtual void reset(){}

    /*! Does this feature need to be trained before use?. 
      
      \return 
    */
    virtual bool needsTraining() { return false; }

    /*! If it does need to be trained, override this function. 
     */
    virtual void train() { }

    /*! Check if feature is trained. 
      
      \return 
    */
    virtual bool isTrained() { return true; }
  };
}

#endif
