/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/


/*! FeaturesConfig.hpp
 * \author Jeshua Bratman
 *
 * Finds, loads, and creates features from feature shared libraries.
 * Also provides methods to train and use these features.
 */

#ifndef FEATURESCONFIG_H
#define FEATURESCONFIG_H

#include "PluginLoader.hpp"
#include "Feature.hpp"
#include "Param.hpp"
#include "SessionManager.hpp"
using namespace CEBL;

//std includes
#include <vector>
using namespace std;

//forward declarations
class CEBLModel;

class FeaturesConfig
{
private:
  //make session manager a friend
  friend class SessionManager;

  CEBLModel *model;

  //features plugins
  PluginLoader<Feature> * plugin_loader;
  PluginLoader<Feature> * getPluginLoader() { return plugin_loader; }

  //selected feature
  string selected_feature;

public:
  FeaturesConfig(CEBLModel *);
  ~FeaturesConfig();

  //GETTING OPERATIONS
  std::vector<string> getNameList();
  std::vector<string> getPathList();
  bool isTrained(string feature = "");
  string getSelected();
  std::map<std::string, CEBL::Param> getParams(string feature = "");


  //SETTING OPERATIONS
  void setSelected(string feature = "");
  void train(string feature = "");
  void reset(string feature = "");
  void setParams(std::map<std::string, CEBL::Param> list, string feature = "");

  //EXTRACT FEATURES
  EEGTrainingData extract(EEGTrainingData &data);
  EEGData extract(EEGData &data);
  void halt();
};

#endif

