/*!
 * FileDataStream.hpp
 * \author Jeshua Bratman
 *
 * An EEG DataStream to generate data from a file.
 */


#include "FileDataStream.hpp"
#include "FileDataStreamConfig.hpp"
#include <cppR/cppR.hpp>
#include <iostream>
using namespace std;
//----------------------------------------------------------------------
// CONSTRUCTORS / DESTRUCTORS

FileDataStream::FileDataStream(CEBLModel *model)
{
  this->model = model;
  this->file_opened = false;
  this->data_index = 0;
}
FileDataStream::~FileDataStream()
{}


//----------------------------------------------------------------------

void FileDataStream::updater()
{
  int num_new_samples = sample_rate * (timeout_length / 1000.0);

  int start_sample = data_index;
  this->data_index += num_new_samples;
  int end_sample = data_index;
  ublas::matrix<double> temp_data;

  if(end_sample >= this->data.numSamples())
    {
      this->data_index = 0;
      start_sample = data_index;
      this->data_index += num_new_samples;
      end_sample = data_index;
    }

  temp_data = cppR::submatrix(this->data.getMatrix(),0,0,start_sample,end_sample);

  //add the temp data to the buffer
  {
    boost::mutex::scoped_lock lock(thread_lock);
    buffer.append(temp_data);
  }

}

void FileDataStream::onStart()
{
  //check to see if file stream configuration is set up correctly
  if(!model->getFileDataStreamConfig()->isReady())
    {
      throw DataSourceException("File data stream is not ready.");
    }
  this->data_index = 0;

  string filename = model->getFileDataStreamConfig()->getFilename();
  this->sample_rate = model->getFileDataStreamConfig()->getSampleRate();
  this->data = model->getFileDataStreamConfig()->getData();
}

void FileDataStream::onStop()
{
  this->data_index = 0;
}




