/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * FileStream.hpp
 * \author Jeshua Bratman
 *
 * An EEG DataStream to output data read from a file.
 */

#ifndef FILEDATASTREAM_H
#define FILEDATASTREAM_H

#include "../CEBLModel.hpp"
#include "EEGDataStream.hpp"
#include "EEGData.hpp"

class FileDataStream : public EEGDataStream
{
private:

  bool file_opened;
  EEGData data;
  int data_index;
  int sample_rate;

  CEBLModel * model;

  void updater();
  void onStart();
  void onStop();

public:
  FileDataStream(CEBLModel *model);
  ~FileDataStream();


};


#endif
