/*! FileDataStreamConfig.cpp
 * \author Jeshua Bratman
 *
 * Configuration for file data stream.
 */

#include "../CEBLModel.hpp"
#include "FileDataStreamConfig.hpp"
#include "EEGTrainingData.hpp"
#include "DataIO.hpp"
#include <fstream>
#include <sstream>
using namespace std;

//----------------------------------------------------------------------
// Constructors / Destructors

FileDataStreamConfig::FileDataStreamConfig(CEBLModel *model)
{
  this->model = model;
  this->filename = "None";
  this->ready = false;
  this->sample_rate = 256;
  this->num_samples = 0;
  this->num_channels = 0;
  this->num_classes = 0;
  this->num_sequences = 0;
}

FileDataStreamConfig::~FileDataStreamConfig(){}



//----------------------------------------------------------------------
// Getting Operations

bool FileDataStreamConfig::isReady()
{
  return this->ready;
}

//----------------------------------------------------------------------
// Setting Operations

void FileDataStreamConfig::openFile(string filename)
{
  this->ready = false;
  this->filename = filename;
  EEGData temp;

  //decide how to load data
  if(filename.find(".tar.bz2") > 0)
    {
      this->training_data = DataIO::loadTrainingDataFromFile(filename);
      this->num_classes = this->training_data.numClasses();
      this->num_sequences = this->training_data.numSequences();
      temp = EEGData(this->training_data.collapse());
    }
  else
    {
      this->num_classes = 0;
      this->num_sequences = 0;
      temp.loadFromFile(filename);
    }

  this->num_samples = temp.numSamples();
  this->num_channels = temp.numChannels();

  if(num_samples < sample_rate || num_channels < 2)
    throw DataException("Not enough data found in file.");

  this->data = temp;
  this->ready = true;
}

void FileDataStreamConfig::setSampleRate(int sample_rate)
{
  this->sample_rate = sample_rate;
}
