/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! FileDataStreamConfig.hpp
 * \author Jeshua Bratman
 *
 * Configuration of file stream for data source tab
 */


#ifndef FILEDATASTREAMCONFIG_H
#define FILEDATASTREAMCONFIG_H

#include "EEGData.hpp"
#include "EEGTrainingData.hpp"
#include <string>
using std::string;

//forward declarations
class CEBLModel;


class FileDataStreamConfig
{
private:
  string filename;
  bool ready;
  CEBLModel * model;
  int sample_rate;
  //the file stream can load either a training data file or an individual data file
  EEGData data;
  EEGTrainingData training_data;

  //information about loaded file
  int num_classes;
  int num_sequences;
  int num_samples;
  int num_channels;

  //selection of classes to use
  std::vector<bool> enabled_classes;
  std::vector<bool> enabled_sequence;


public:
  FileDataStreamConfig(CEBLModel *);
  ~FileDataStreamConfig();

  //GETTING OPERATIONS
  string getFilename() { return filename; }
  int getSampleRate() { return sample_rate; }
  bool isReady();
  int getNumSamples() { return num_samples; }
  int getNumChannels() { return num_channels; }
  EEGData &getData() { return data; }
  EEGTrainingData &getTrainingData() { return training_data; }
  int getNumClasses() { return num_classes; }
  int getNumSequences() { return num_sequences; }

  //SETTING OPERATIONS
  void openFile(string filename);
  void setSampleRate(int sample_rate);
};


#endif
