/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! Filter.hpp
 * \author Jeshua Bratman
 *
 * Provides interface for filter plugins.
 *
 */


#ifndef FILTER_H
#define FILTER_H

#include "Plugin.hpp"
#include "cppR/cppR.hpp"
#include <vector>


namespace CEBL
{
  class Filter : public Plugin
    {
    protected:
      //filter created
      bool created;

    public:
      Filter() { created = false; }
      virtual ~Filter() {}
      bool isTrained() { return created; }


      //-----------------------------------------------------------------
      //Function to override below VVVVV

      virtual void make(const ublas::matrix<double> &,
                        const std::vector<int> &) = 0;

      virtual ublas::matrix<double> apply(const ublas::matrix<double> &)
        const = 0;

      virtual ublas::matrix<double> extract(const ublas::matrix<double> &) = 0;

      virtual ublas::matrix<double> getFilterMatrix() = 0;
  };
}

#endif
