/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/


/*! FilterConfig.hpp
 * \author Jeshua Bratman
 *
 * Finds, loads, and creates filters from filter shared libraries. Also provides methods to train and use these filters.
 */

#ifndef FILTERCONFIG_H
#define FILTERCONFIG_H

#include "PluginLoader.hpp"
#include "Filter.hpp"
#include "EEGData.hpp"
#include "SessionManager.hpp"
using namespace CEBL;

//std includes
#include <vector>
using namespace std;

//forward declarations
class CEBLModel;

class FilterConfig
{
private:
  //make session manager a friend
  friend class SessionManager;

  CEBLModel *model;

  //filter plugins
  PluginLoader<Filter> * plugin_loader;
  PluginLoader<Filter> * getPluginLoader() { return plugin_loader; }

  std::vector<int> selected_components;
  string selected_components_string;
  bool selected_components_valid;
  string selected_filter;
  int num_lags;
  int num_components;
  int num_channels;

  //values to check what settings the filter was trained on
  int num_expected_channels;
  int num_expected_lags;
  bool trained;

public:
  FilterConfig(CEBLModel *);
  ~FilterConfig();

  //GETTING OPERATIONS
  std::vector<string> getNameList();
  std::vector<string> getPathList();
  bool isTrained(string filter = "");
  int getNumLags();
  string getSelected() { return selected_filter; }
  std::vector<int> getSelectedComponents();
  string getSelectedComponentsString();
  bool getSelectedComponentsValid();
  EEGData apply(EEGData data);
  int getNumExpectedChannels();
  ublas::matrix<double> getFilterMatrix();

  //SETTING OPERATIONS
  void setSelectedComponentsString(string components);
  void setSelected(string filter = "");
  void setNumLags(int lags);
  void train(EEGData training_data, string filter = "");
  EEGData getComponents(EEGData training_data);
};

#endif

