/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * MindsetStream.hpp
 * \author Jeshua Bratman
 *
 * An EEG DataStream to
 */

#ifndef MINDSETDATASTREAM_H
#define MINDSETDATASTREAM_H

#include "EEGDataStream.hpp"
#include "Mindset24.hpp"

class MindsetStream : public EEGDataStream
{

private:

  void updater();
  void onStart();
  void onStop();

  CEBLModel * model;
  Mindset24 mindset;

public:
  MindsetStream(CEBLModel * model);
  ~MindsetStream();


};


#endif
