/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! Classifier.hpp
 * \author Jeshua Bratman
 *
 * Provides interface for plugins.
 *
 */

#ifndef CEBLPLUGIN_H
#define CEBLPLUGIN_H

#include <string>
#include <map>

#include "CEBLSerialization.hpp"
#include "../Exceptions.hpp"
#include "../Param.hpp"

using std::string;
using std::map;
using CEBL::SerializedObject;

namespace CEBL
{

  //----------------------------------------------------------------------

  class Plugin
  {
  protected:
    string plugin_name;
    bool should_halt;

    //function to inturrupt long calculation if ordered to halt
    void inturruptionPoint()
    {
      if(should_halt)
        {
          should_halt = false;
          throw InturruptException(plugin_name + " was inturrupted.");
        }
    }


  public:
    Plugin() { plugin_name = "Unnamed Plugin"; should_halt = false;}
    virtual ~Plugin() {}

    //! tell classifier to halt
    void halt() { should_halt = true; }

    //! get the name of the plugin
    string getName() const { return plugin_name; }

    //----------------------------------------------------------------------
    //Function to override

    //! get the parameter list
    virtual std::map<std::string, CEBL::Param> getParamsList()
    {
      std::map<std::string, CEBL::Param> params;
      return params;
    }
    //! set the parameter list
    virtual void setParamsList( std::map<std::string, CEBL::Param> &){}

    //! save plugin to list, and return it
    virtual map<string, SerializedObject> save() const 
    {
      map<string, SerializedObject> ret;
      return ret;
    }

    //! load plugin from list of objects
    virtual void load(map<string, SerializedObject> objects) {}

  };
}
#endif
