/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/


/*! Preferences.hpp
 * \author Jeshua Bratman
 *
 * Loads and stores CEBL preferences.
 */

//handle defines
#ifndef DATAROOTDIR
#define DATAROOTDIR "/usr/local/cebl"
#endif
#ifndef PACKAGE
#define PACKAGE "cebl"
#endif
#ifndef PACKAGE_STRING
#define PACKAGE_STRING "cebl-0.0"
#endif

#ifndef PREFERENCES_H
#define PREFERENCES_H

#include <boost/program_options.hpp>
namespace po = boost::program_options;

class Preferences
{
private:
  //description of options
  po::options_description desc;

  std::string conf_dir;
  //set options
  std::map<string, string> set_options;
  std::vector<string> option_list;

  bool have_conf_dir;

  //load this session file on load
  string session_filename;

  //channels
  string default_channels_filename;
  string string_table_filename;

  //preferences
  std::vector<std::string> paths;
public:

  Preferences();
  ~Preferences();

  bool initCEBL();
  bool processCL(int ac, char ** av);
  std::vector<std::string> getPaths() const { return paths; }
  string getDefaultChannelsFilename();
  string getSessionFilename() { return session_filename; }
  string getStringTableFilename() { return string_table_filename;}

  //options
  void addOption(string name, string description, char short_name = '\0');
  string getOption(string name);
};

#endif
