/*!
 * RandomDataStream.hpp
 * \author Jeshua Bratman
 *
 * An EEG DataStream to generate random data.
 */


#include "RandomDataStream.hpp"
#include <cppR/cppR.hpp>
#include <iostream>
using namespace std;
//----------------------------------------------------------------------
// CONSTRUCTORS / DESTRUCTORS

RandomDataStream::RandomDataStream()
{}
RandomDataStream::~RandomDataStream()
{}


//----------------------------------------------------------------------

void RandomDataStream::updater()
{
  int samples = sample_rate * (timeout_length / 1000.0);
  ublas::matrix<double> data
    = cppR::createMatrix(static_cast<ublas::vector<double> >(cppR::runif<double>(24 * samples)),
        		 24,samples);

  data *= 8;

  {
    boost::mutex::scoped_lock lock(thread_lock);
    buffer.append(data);
  }

}

void RandomDataStream::onStart()
{
}

void RandomDataStream::onStop()
{
}




