/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! RealTimeClassification.hpp
 * \author Jeshua Bratman
 *
 * Controls real-time classifying.
 */


#ifndef REALTIMECLASSIFICATION_H
#define REALTIMECLASSIFICATION_H

//std includes
#include <vector>
#include "TimeoutThread.hpp"
using namespace std;

//forward declarations
class CEBLModel;

class RealTimeClassification : public TimeoutThread
{
private:
  CEBLModel *model;

  std::vector<double> class_proportions;
  std::vector<int> classification_queue;
  int selected_class;
  bool is_classifying;

  //train classifier thread
  boost::thread * train_classifier_thread;
  bool currently_training_classifier;
  bool halt_training;
  bool training_failed;
  //! friend function to run trainClassifier
  friend void runTrainClassifier(RealTimeClassification *);

public:
  RealTimeClassification(CEBLModel *);
  ~RealTimeClassification();

  //GETTING OPERATIONS

  bool isReady() const;
  bool isClassifying() const;
  bool lastTrainFailed() const { return training_failed; };
  std::vector<int> readClassificationQueue();
  std::vector<int> peekClassificationQueue() const;
  std::vector<double> getClassProportions() { return class_proportions; }
  int getSelectedClass() const { return selected_class; }
  void clearSelectedClass() { selected_class = -1; }

  //SETTING OPERATIONS
  void clearClassificationQueue();

  //CONTROL CLASSIFICATION
  void trainClassifier();
  void trainClassifierThreaded();
  bool isTrainingClassifier();
  void trainClassifierHalt();
  void startClassifying();
  void stopClassifying();


  //function required by timeoutFunction interface
  void timeoutFunction();

};

#endif

