/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

//Serialization used in CEBL. The plugins need a separate file.
#ifndef CEBLBOOSTSERIALIZATION_H
#define CEBLBOOSTSERIALIZATION_H

//seems to be needed for some reason, 
//otherwise with get a problem at vector.hpp:126
#define BOOST_NO_INTRINSIC_INT64_T 

#include <boost/archive/text_iarchive.hpp>
#include <boost/archive/text_oarchive.hpp>
#include <boost/serialization/base_object.hpp>
#include <boost/serialization/utility.hpp>

#include <boost/serialization/vector.hpp>
#include <boost/serialization/map.hpp>
#include <boost/serialization/string.hpp>

//ublas includes
#include <boost/numeric/ublas/vector.hpp>
#include <boost/numeric/ublas/matrix.hpp>
#include <boost/static_assert.hpp>
#include "cppR/cppR.hpp"
//----------------------------------------------------------------------

namespace ublas = boost::numeric::ublas;

namespace boost{
  template <> struct STATIC_ASSERTION_FAILURE<false> { enum { value = 0 }; };
}

namespace boost {
  namespace serialization {
    //! Serialize a ublas matrix to a file.
    template<class Archive, class T>
    void save(Archive & ar, const ublas::matrix<T> & mat, const unsigned int version)
    {
      std::vector<std::vector<T> > newmat;
      newmat.resize(0);
      if(mat.size1() > 0)
        {
          for(unsigned row=0;row < mat.size1(); row++)
            {
              std::vector<T> row_vec;
              newmat.push_back(row_vec);
              for(unsigned col=0;col < mat.size2(); col++)
                {
                  newmat.at(row).push_back(mat(row,col));
                }
            }
        }
      ar & newmat;
    }

    //! Serialize a ublas matrix from a file.
    template<class Archive, class T>
    void load(Archive & ar, ublas::matrix<T> & mat, const unsigned int version)
    {
      
      std::vector<std::vector<T> > loadedmat;
      ar & loadedmat;
      if(loadedmat.size() > 0)
        {
          int nrows = loadedmat.size();
          int ncols = loadedmat.at(0).size();
          mat.resize(nrows,ncols);
          for(unsigned row=0; row<mat.size1(); row++)
            {
              for(unsigned col=0;col < mat.size2(); col++)
                {
                  mat(row,col) = loadedmat.at(row).at(col);
                }
            }
        }
     }


    //! Split serialization of matrix to a save and load functons.
    template<class Archive, class T>
    void serialize(Archive & ar, ublas::matrix<T> & mat,const unsigned int file_version)
    {
      boost::serialization::split_free(ar, mat, file_version);
    }

    //! Serialize a ublas vector to a file.
    template<class Archive, class T>
    void save(Archive & ar, const ublas::vector<T> & vec, const unsigned int version)
    {
      std::vector<T> newvec = cppR::asStdVector(vec);
      ar & newvec;
    }

    //! Serialize a ublas vector from a file.
    template<class Archive, class T>
    void load(Archive & ar, ublas::vector<T> & vec, const unsigned int version)
    {
      std::vector<T> newvec;
      ar & newvec;
      vec = cppR::asUblasVector(newvec);
    }

    //! Split serialization of vector to a save and load functons.
    template<class Archive, class T>
    void serialize(Archive & ar, ublas::vector<T> & vec,const unsigned int file_version)
    {
      boost::serialization::split_free(ar, vec, file_version);
    }
  } // namespace serialization
} // namespace boost

#endif
