/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! SessionManager.hpp
 * \author Jeshua Bratman
 *
 * Manages saving and loading data from model.
 */

#ifndef SESSIONMANAGER_H
#define SESSIONMANAGER_H

#include "../CEBLIncludes.hpp"

//forward declarations
class CEBLModel;
class Session;

class SessionManager
{
private:
  Session *current_session;
  CEBLModel *model;

  //! Update the model from the session
  void updateModel();
  //! Update the session from the model
  void updateSession();

  string decodeKey(string);
  string encodeKey(string);

public:
  SessionManager(CEBLModel *);
  ~SessionManager();


  void save();
  void saveAs(string filename);
  void load(string filename);

  bool shouldSaveAs();

};

#endif
