/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * SharedLoaderFactory.hpp
 * \author Jeshua Bratman
 *
 * Scans directories for shared libraries, and creates objects interfacing with those libraries.
 */

#ifndef SHAREDLOADERFACTORY_H
#define SHAREDLAODERFACTORY_H

#include "SharedLoader.hpp"
#include "../FileUtils.hpp"

#include <map>
#include <string>
#include <sstream>
#include <vector>
using namespace std;
namespace fs = boost::filesystem;

template <typename T>
class SharedLoaderFactory
{
private:
  map<string, SharedLoader<T> > libs;
  map<string, string > paths;

public:
  SharedLoaderFactory(){};
  ~SharedLoaderFactory();

  void Scan(std::vector<string> dirs) {
    for(int i=0; i<dirs.size(); i++)
      {
        Scan(dirs[i]);
      }
  };
  void Scan(string);
  map<string, SharedLoader<T> > &GetMap() { return libs; };
  map<string, string > &GetPaths() { return paths; };
};

//DESTRUCTOR
template <typename T>
SharedLoaderFactory<T>::~SharedLoaderFactory()
{

}


//Scans a directory for all shared libraries and loads them
template <typename T>
void SharedLoaderFactory<T>::Scan(string directory)
{
  fs::path full_path;
  full_path = fs::system_complete(fs::path(directory, fs::native));


  //make sure directory exists
  if(!fs::exists(full_path))
    {
      std::cout << "Directory does not exist: " << full_path.native_file_string() << std::endl;
      return;
    }
  //make sure it is a directory
  if(!fs::is_directory(full_path))
    {
      std::cout << full_path.native_file_string() << " is not a directory. "<< std::endl;
      return;
    }


  //loop through directory
  fs::directory_iterator end_iter;
  for (fs::directory_iterator dir_itr( full_path );
       dir_itr != end_iter;
       ++dir_itr )
    {
      try
        {
          string file = dir_itr->leaf();

          if(file.length() > 3)
            {
              if(file.substr(file.length()-3,3) == ".so")
        	{
        	  string name = file.substr(0,file.length()-3);
        	  string full_name = full_path.native_file_string() + "/"+file;
        	    libs[name].LoadLibrary(full_name.c_str());
        	  paths[name] = directory;
        	  if(libs[name].Loaded())
        	    {
        	      //cout << "Loaded shared library: " << name << ".so" << endl;
        	    }
        	  else
        	    {
        	      //remove entry
        	      libs.erase(name);
        	    }
        	}
            }
        }
      catch ( const std::exception & ex )
        {}
    }

}
#endif
