#include <map>
#include <string>
#include <fstream>
#include <istream>
#include <sstream>
#include <iostream>
#include <sstream>
#include <algorithm>
#include <boost/regex.hpp>
using namespace std;
using namespace boost;

#include "StringTable.hpp"
#include "../Exceptions.hpp"
#include "../CompiledStrings.hpp"


StringTable::StringTable(){}


void StringTable::loadFromFile(string filename)
{
  ifstream ifs(filename.c_str());
  if(!ifs.is_open())
    {
      throw FileException("String table failed to open \"" + filename + "\".");
    }
  this->load(ifs);
}


void StringTable::loadFromString(string string_table)
{
  string_table = regex_replace(string_table,
                               regex(str_table_linebreak_str),"\n");
  stringstream is;
  is << string_table;
  this->load(is);
}


void StringTable::load(istream &is)
{
  string line;
  string buffer;

  //now parse the file
  regex string_regexp(string(
                             "^[[:space:]]*(\\w+)[[:space:]]*=")
                      +"[[:space:]]*\"(.+)\"[[:space:]]*");

  //loop through file
  while(!is.eof())
    {
      // get the next line
      getline(is, buffer);
      line = buffer;

      bool valid = regex_search(line,string_regexp);

      //check if search failed
      if(!valid)
        {
          //         cerr << "StringTable: Bad line: " << line << endl;
        }
      else
        {
          cmatch what;
          regex_match(line.c_str(), what, string_regexp);
          strings[what[1]] = decodeString(what[2]);
        }
    }
}

const char * StringTable::getString(string string_name)
{
  if(strings.count(string_name))
    {
      return strings[string_name].c_str();
    }
  else
    {
      throw StringTableException("Cannot find string of name " + string_name);
    }
}


string StringTable::decodeString(string str)
{
  //cout << "string = " << str << "\n";
  string ret;
  ret = regex_replace(str,
                      regex("\\\\[n]"),"\n");
  ret = regex_replace(ret,
                      regex("\\\\[t]"),"\t");
  ret = regex_replace(ret,
                      regex("\\\\[\"]"),"\\\"");
  //cout << "string = " << ret << "\n";
  return ret;
}
