/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * \class StringTable
 * \author Jeshua Bratman
 *
 * String table implementation.
 */

class StringTable
{
private:
  map<std::string, std::string> strings;
  string filename;

  string decodeString(string str);

  void load(istream &is);

public:
  StringTable();

  /*! Load strings from file

    Throws: StringTableException, FileException
    \param filename file to load string table from
  */
  void loadFromFile(string filename);

  /*! Loads string from string table encoded in specified string.
    \param str string table
  */
  void loadFromString(string str_table);

  /*! Get a string by name from the string table.

    Throws: StringTableException
    
    \return full string
  */
  const char * getString(string string_name);
};

