/*! TimeoutThread.hpp
 * \author Jeshua Bratman
 *
 * Simple interface for classes which require a function to be run as a timeout.
 * Uses boost threading library.
 */

#include "TimeoutThread.hpp"
#include <boost/thread/xtime.hpp>
#include <boost/bind.hpp>
#include "../Exceptions.hpp"

#include <iostream>
using namespace std;

TimeoutThread::TimeoutThread()
{
  halt = false;
  halted = true;
  is_started = false;
  //in milliseconds
  timeout_length = 100;

  updater_thread = NULL;
}

TimeoutThread::~TimeoutThread()
{
  if(isStarted())
    haltAndJoin();
  if(updater_thread != NULL)
    delete updater_thread;
}


void TimeoutThread::haltAndJoin()
{
  if(updater_thread == NULL)
    {
      is_started = false;
      return;
    }
  halt = true;
  updater_thread->join();
  delete updater_thread;
  updater_thread = NULL;
  is_started = false;

}

void runTimeoutThread(TimeoutThread *t)
{
  t->timeoutRunner();
}


void TimeoutThread::timeoutStart()
{
  if(!isStarted() && updater_thread == NULL)
    {
      halt = false;
      halted = false;
      is_started = true;
      updater_thread = new boost::thread(boost::bind(&runTimeoutThread, this));
    }
}


void TimeoutThread::timeoutRunner()
{

  while(true)
    {
      if(!halt)
        {
          try
            {
              this->timeoutFunction();
            }
          catch(exception e)
            {
              halt = true;
              cerr << "Halted timeout due to exception: "  << e.what() << "\n";
            }
          catch(const char *m)
            {
              halt = true;
              cerr << "Halted timeout due to exception: "  << m << "\n";
            }
        }
      if(halt)
        {
          halted = true;
          break;
        }

      //sleep for a timeout_length time
      sleep(timeout_length);
    }

}


void TimeoutThread::sleep(double stime)
{
  boost::xtime xt;
  boost::xtime_get(&xt,boost::TIME_UTC);
  xt.nsec += stime * 1000000;
  boost::thread::sleep(xt);
}



