/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! TimeoutThread.hpp
 * \author Jeshua Bratman
 *
 * Simple interface for classes which require a function to be run as a timeout.
 * Uses boost threading library.
 */


#include <boost/thread/thread.hpp>
#include <boost/thread/mutex.hpp>


#ifndef TIMEOUTTHREAD_H
#define TIMEOUTTHREAD_H


class TimeoutThread
{
 private:
  //! updating funcation
  void timeoutRunner();
  //! friend function to start timeout
  friend void runTimeoutThread(TimeoutThread *);

 protected:
  //! the thread object
  boost::thread * updater_thread;
  //! flag to indicate whether or not the thread is started
  bool is_started;
  //! flag to order thread to halt on next iteration
  bool halt;
  //! flag to indicate whether or not thread has hlated
  bool halted;
  //! mutex to lock the thread
  boost::mutex thread_lock;
  //! how often updater is called
  double timeout_length;

  //OVERRIDE THESE
  virtual void timeoutFunction() = 0;

  //! start the thread
  void timeoutStart();

  //! halt the thread and wait for it to finish
  void haltAndJoin();

  //! sleep for stime in milliseconds
  void sleep(double stime);
 public:
  TimeoutThread();
  virtual ~TimeoutThread();

  bool isHalted() { return halted;};
  bool isStarted() { return is_started;}
  //! get length of timeout in milliseconds
  double getTimeoutLength() { return timeout_length; }
  //! set length of timeotu in milliseconds
  void setTimeoutLength(double l) { timeout_length = l; }



};


#endif
