/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*!
 * Timer.hpp
 * \author Jeshua Bratman
 *
 * Simple timer class.
 */

#ifndef TIMER_H
#define TIMER_H

#include <stdio.h>
#include <sys/timeb.h>

class Timer
{
private:
  timeb start_time;
public:
  Timer()
  {
    restart();
  }

  //restart timer to 0
  void restart()
  {
    ftime(&start_time);
  }
  //time elapsed in milliseconds
  long elapsed()
  {
    timeb current_time;
    long diff;
    ftime(&current_time);
    diff = (long) (1000.0 * (current_time.time - start_time.time)
        	   + (current_time.millitm - start_time.millitm));
    return diff;
  }


};

#endif
