/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

#ifndef LDA_H
#define LDA_H

#include "../model/Classifier.hpp"

namespace CEBL
{
  class LDA : public Classifier
  {
  private:
    ublas::vector<double> priors;
    ublas::matrix<double> means;
    ublas::matrix<double> covariance;
    ublas::matrix<double> covarianceInv;
    ublas::vector<int> classes;
    ublas::matrix<double> weights;
    ublas::vector<double> bias;




  public:
    LDA() { plugin_name = "LDA"; }

    //! train classifier over training data set
    void train(const EEGTrainingData &);

    //! use classifier on data and return class
    ublas::vector<int> use(const ublas::matrix<double> &);

    //! get and set the parameter list to the feature extractor
    std::map<std::string, CEBL::Param> getParamsList();
    void setParamsList( std::map<std::string, CEBL::Param> &);

    //saving and loading
    map<string, SerializedObject> save() const;
    void load(map<string, SerializedObject> objects);

  };
}
#endif
