/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

#ifndef QDA_H
#define QDA_H

#include "../model/Classifier.hpp"

namespace CEBL
{
  class QDA : public Classifier
  {
  private:
    ublas::vector<double> priors;
    ublas::matrix<double> means;
    std::vector<ublas::matrix<double> > covariances;
    std::vector<ublas::matrix<double> > covariancesInv;
    ublas::vector<double> covariancesDet;
    ublas::vector<int> classes;

  public:
    QDA() { plugin_name = "QDA"; }

    //! train classifier over training data se
    void train(const EEGTrainingData &);

    //! use classifier on data and return class
    ublas::vector<int> use(const ublas::matrix<double> &);

    //! get and set the parameter list to the feature extractor
    std::map<std::string, CEBL::Param> getParamsList();
    void setParamsList( std::map<std::string, CEBL::Param> &);

    //saving and loading
    map<string, SerializedObject> save() const;
    void load(map<string, SerializedObject> objects);


  };
}
#endif
