#Include "max_var.hpp"
using namespace cppR;
using namespace ublas;
using namespace std;

namespace CEBL
{
  /**
      get and set the paramater list to the feature extractor
  */
  std::map<std::string, CEBL::Param> max_var::getParamsList()
  {
    std::map<std::string, CEBL::Param> params;//no paramaters for the max_var classifier
    CEBL::Param threshold_param("Threshold", "Variance Threshold.", thresh);
    //thresh.setMax(500.0);
    //thresh.setMin(0.0);
    params["threshold_param"] = threshold_param;
    return params;
  }
  void max_var::setParamsList( std::map<std::string, CEBL::Param> &p)
  {
    thresh = double((*(p.begin())).getDouble());
  }


  /** Train classifier over training data **/
  void max_var::train(const EEGTrainingData& data)
  {

  }
  /** use classifier on data and return class */
  std::vector<int> max_var::use(const ublas::matrix<double> & data) const
  {
    ublas::matrix<double> d = data;
    std::vector<int> ret;
    ret.resize(1);
    double var = sd(t(d))[0];
    cout << "Var = " << var << "\n";
    ret[0] = var > thresh ? 0 : 1;
    return ret;
  }


  /** serialize class for saving and loading classifier */
  void max_var::save(boost::archive::text_oarchive &ar, const unsigned int &version) const
  {
  }
  void max_var::load(boost::archive::text_iarchive &ar, const unsigned int &version)
  {
  }
}
/*************************************************************/
//DYNAMIC LOADING

extern "C" CEBL::Classifier* ObjectCreate()
{
  printf("Shared Library Says: Creating a max_var object.\n");
  return new CEBL::max_var;
}

extern "C" void ObjectDestroy(CEBL::Classifier* p)
{
  delete p;
}
