/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

#ifndef max_var_H
#define max_var_H
//relative to cebl source dir
#include "../model/Classifier.hpp"

namespace CEBL
{
  class max_var : public Classifier
  {
  private:

    /** serialize class for saving and loading classifier */
    friend class boost::serialization::access;

    /** save lda to archive */
    void save(boost::archive::text_oarchive &ar, const unsigned int &version=0) const;
    /** load lda from archive */
    void load(boost::archive::text_iarchive &ar, const unsigned int &version=0);

    double thresh;

  public:
    /** constructor sets trained to false **/
    max_var() { trained = true; };
    ~max_var() {};

    /** get and set the parameter list to the feature extractor **/
    std::map<std::string, CEBL::Param> getParamsList();
    void setParamsList( std::map<std::string, CEBL::Param> &);

    /** train classifier over training data set*/
    void train(const EEGTrainingData &);

    /** use classifier on data and return class */
    std::vector<int> use(const ublas::matrix<double> &) const;
  };
}
#endif
