/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! MSPRT.hpp
 * \author Jeshua Bratman
 *
 * Decison plugin for multihypothesis sequential ratio test
 *
 */

#ifndef MSPRT_H
#define MSPRT_H

#include "../model/Decision.hpp"

namespace CEBL
{
  class MSPRT : public Decision
  {
  private:
    ublas::vector<double> sums;
    ublas::vector<double> log_probs;
    double log_threshold;
    double threshold;
    double g;


  public:
    MSPRT();
    ~MSPRT();

    void updateWithProbabilities(std::vector<double> probs);
    std::vector<double> decideClasses();
    void init(int num_classes);

    //params
    std::map<std::string, CEBL::Param> getParamsList();
    void setParamsList( std::map<std::string, CEBL::Param>&);

    //saving and loading
    map<string, SerializedObject> save() const;
    void load(map<string, SerializedObject> objects);

  };
}


#endif
