/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! SimpleMax.hpp
 * \author Jeshua Bratman
 *
 * Decison plugin for multihypothesis sequential ratio test
 *
 */

#ifndef SimpleMax_H
#define SimpleMax_H

#include "../model/Decision.hpp"

namespace CEBL
{
  class SimpleMax : public Decision
  {
  private:
    std::vector<double> proportions;
    double growth_rate;
    double shrink_rate;

  public:
    SimpleMax();
    ~SimpleMax();
    void init(int num_classes);

    void updateWithProbabilities(std::vector<double> probs);
    std::vector<double> decideClasses();


    //params
    std::map<std::string, CEBL::Param> getParamsList();
    void setParamsList( std::map<std::string, CEBL::Param>&);

    //saving and loading
    map<string, SerializedObject> save() const;
    void load(map<string, SerializedObject> objects);

  };
}


#endif
