#include "Lag.hpp"

using namespace cppR;

namespace CEBL
{
  //default constructor
  Lag::Lag()
  {
    n_lags = 0;
    bufferEmpty=true;
    plugin_name = "Lag";
  }

  //! get list of parameters needed for feature
  std::map<std::string, CEBL::Param> Lag::getParamsList()
  {
    std::map<std::string, CEBL::Param> params;
    CEBL::Param lags("Lags", "How many lags?", n_lags);
    lags.setMax(500);
    lags.setMin(0);
    params["lags"] = lags;

    return params;
  }

  //! set list of parameters
  void Lag::setParamsList(std::map<std::string, CEBL::Param> &p)
  {
    int new_lags = p["lags"].getInt();

    if(new_lags != n_lags)
      {
        cout << "setting lags to " << new_lags << "\n";
        n_lags = new_lags;
        reset();
      }
  }


  //! featureize data and return the result
  ublas::matrix<double> Lag::use(const ublas::matrix<double> &data)
  {
    bool debug = false;
    if(debug)
      {
        cout << "using lags: " << endl;
        cout << "Lag.cpp: data is" << nrow(data) << " by " << ncol(data) << endl;
        cout << "Num lags is " << n_lags << endl;
      }
      if (n_lags > 0) {
        if (bufferEmpty) {
           buffer = data;
           bufferEmpty = false;
        } else {
           // cbind (concatentate) new data onto right side of buffer
           int nRowsBuffer = nrow(buffer);
           int nColsBuffer = ncol(buffer);
           //int nRowsData = nrow(data);
           int nColsData = ncol(data);
           if(debug)
             {
               cout << "Lag.cpp: data is" << nrow(data) << " by " << ncol(data) << endl;
               cout << "Lag.cpp:  buffer was " << nrow(buffer) << " by " << ncol(buffer) << endl;
             }
           ublas::matrix<double> keep =
              submatrix(buffer,0,nRowsBuffer-1,
                 nColsBuffer-n_lags, nColsBuffer-1);
           buffer = keep;
           buffer.resize(nRowsBuffer, n_lags+nColsData);
           nColsBuffer = ncol(buffer);
           submatrix(buffer, 0, nRowsBuffer-1,
              nColsBuffer-nColsData, nColsBuffer-1) = data;
           if(debug)
             cout << "Lag.cpp:  buffer now " << nrow(buffer) << " by " << ncol(buffer) << endl;
        }

        // will produce error if n_lags >= ncol(buffer)
        return cppR::Lag(buffer,n_lags);
     } else {

        // n_lags == 0
        return data;

     }
  }

  map<string, SerializedObject> Lag::save() const
  {
    map<string, SerializedObject> ret;
    ret["n_lags"] = serialize(n_lags);

    return ret;
  }
  void Lag::load(map<string, SerializedObject> objects)
  {
    deserialize(objects["n_lags"], n_lags);
  }

  //! reset the lag buffer
  void Lag::reset()
  {
    buffer.resize(0,0);
    bufferEmpty = true;
  }

}

/*************************************************************/
//DYNAMIC LOADING

extern "C" CEBL::Feature* ObjectCreate()
{
  return new CEBL::Lag;
}

extern "C" void ObjectDestroy(CEBL::Feature* p)
{
  delete p;
}
