/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

#ifndef FEATURELAG_H
#define FEATURELAG_H

//relative to cebl source dir
#include "model/Feature.hpp"

namespace CEBL
{
  class Lag : public Feature
  {
  private:
    int n_lags;

     ublas::matrix<double> buffer;
     bool bufferEmpty;


  public:
    Lag();

    //! get and set the parameter list to the feature extractor
    std::map<std::string, CEBL::Param> getParamsList();
    void setParamsList(std::map<std::string, CEBL::Param> &);

    //! use feature on data and return new matrix
    ublas::matrix<double> use(const ublas::matrix<double> &);

    //! reset the buffer
    void reset();

    //saving and loading
    map<string, SerializedObject> save() const;
    void load(map<string, SerializedObject> objects);

  };
}

#endif
