/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

#ifndef PASSBAND_H
#define PASSBAND_H
//relative to cebl source dir
#include "features/Feature.hpp"
#include "PassBandFunctions.hpp"

#include <map>
using namespace std;


namespace CEBL
{

  struct PassBandGUIRow
  {
    GtkWidget *spin_low,*spin_high;
  };

  struct ConfigRow
  {
    int low, high;
  };


  class PassBand : public Feature
  {
  private:
    //widgets
    GtkWidget *gui_container,
      *spin_bands,
      *table_bands,
      *check_trained,
      *check_variance,
      *spin_gamma;


    vector<PassBandGUIRow> widget_rows;
    vector<ConfigRow> config_rows;
    map<int, map<int, map<int, ublas::matrix<double> > > > configurations;
    map<int, ublas::matrix<double> > filters;
    //means and vars are vectors for each num band, for each feature
    vector< vector<double> > means;
    vector< vector<double> > vars;
    vector<FilterState> states;
    int num_bands;
    bool trained;
    double gamma;

    //set up gui
    void InitGUI();

    //callbacks
    void ChangeNumBands(int force_bands=-1);
    void ChangeOptions(int pos = 0);

    static void CB_ChangeNumBands(GtkWidget *spin, gpointer data);
    static void CB_ChangeOptionsLow(GtkWidget *spin, gpointer data);
    static void CB_ChangeOptionsHigh(GtkWidget *spin, gpointer data);
    static void CB_ChangeGamma(GtkWidget *spin, gpointer data);

    //saving and loading
    map<string, SerializedObject> save() const;
    void load(map<string, SerializedObject> objects);

  public:
    //default constructor - initializes members
    PassBand();

    //! use feature on data and return new matrix
    ublas::matrix<double> use(const ublas::matrix<double> &);

    //! training
    bool needs_training() { return true; }
    void train();
    bool isTrained() { return trained; }



  };

}//end namespace


#endif
