/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

#ifndef PASSBANDFUNCTIONS_H
#define PASSBANDFUNCTIONS_H


#include <fftw3.h>
#include "cppR.hpp"

typedef ublas::matrix<double> Matrix;
struct FilterState
{
  bool empty;
  Matrix x;
  Matrix y;
};

struct FilterResult
{
  Matrix filtered;
  FilterState state;
};

std::vector<int> localMax(ublas::matrix<double>);
ublas::matrix<double> convolve(ublas::matrix<double> x, ublas::matrix<double> y);
Matrix chebbp2(int N, int L, double wp, double ws1, double ws2);
Matrix makePassband(int N, int L, int Fs, double fstop1, double fpass, double fstop2);
ublas::matrix<double> convolve(ublas::matrix<double> x, ublas::matrix<double> y);
FilterResult filter(Matrix B, Matrix x, FilterState state);

#endif
