cat("From filterExample.R:\n")
cat(" Sourcing main functions: filterExample\n")

source("makePassband.R")

source("jensen.R")

cat("\n")
cat("run  filterExample()  \n")

######################################################################
filterExample <- function() {
  cat("Calling makePassband to create 20-30 Hz filter for signals with Fs=512\n")
  Fs <- 256
  ## 151 is number of coefficients in filter. Must be odd.
  ## 8 is number of derivatives at 25 Hz of freq response should be zero.
  ## Fs is sample rate
  ## 20, 30, lower and upper limits of passband in Hz
  B <- makePassband(151,8,Fs,20,25,30)
  return();
  A <- c(1)
  cat("Creating 5 seconds of 3 channel random data from Gaussian process.\n")
  x <- as.matrix(read.table(file="test.txt"));#matrix(rnorm(3*Fs*5),nrow=3)
  cat("Filtering the data.\n")
  ## A should always be c(1).
  r <<- myfilter(B,A,x)
  v <- read.table("v.txt");
  cat("DIFF= ",max(abs(v-inv)),"\n");
  return();
  y <- r$filtered
  names <- c(paste("Original",1:3), paste("Filtered",1:3))
  cat("Showing continuous wavelet transform of original and filtered data\n")
  z<-jensen(rbind(x,y),names,Fs,5:60,5)
}

