cat("From jensen.R:\n")
cat(" Sourcing main functions: jensen\n")
cat(" Sourcing secondary functions: morletLength, energyvec, morlet, convolve\n")

jensen <- function(eeg,channelnames,Fs,freqs,width,graphics) {
### r <- jensen(eeg,channelnames,Fs,freqs,width,graphics)
###   r$tfrep,  r$tfrepPhase                   
### Example using Keirn data:
###  load_eegdata;
###  tfrep = jensen(eegdata{1,1,2},eegdata_rows,250,1:40,20);
###
### Example 2:
### load ../proj/data/first_run/08_7_04
### load ../Mindset/eegViewer/clean08_7_04
### tfrep = jensen(clean{5,1},experiment.channels,256,5:40,20);

  if (missing(graphics))
    graphics <- TRUE

  if (is.null(channelnames))
    channelnames <- paste("Channel",1:nrow(eeg))

  nchannels <- nrow(eeg)
  nsamples <- ncol(eeg)

  nfreqs <- length(freqs)
  tfrep <- array(0, c(nchannels, nfreqs, nsamples))
  tfrepPhase <- array(0, c(nchannels, nfreqs, nsamples))

  for (ch in 1:nchannels) {
    for (freqi in 1:nfreqs) {
      r <- energyvec(freqs[freqi],eeg[ch,],Fs,width)
      mag <- r$mag
      phase <- r$phase
      tfrepPhase[ch,freqi,1:length(phase)] <- phase
      tfrep[ch,freqi,1:length(mag)] <- mag;
    }
  }

  if (graphics) {

    nrows <- floor(sqrt(nchannels))
    if (nrows*nrows < nchannels)
      nrows <- nrows + 1
    ncols <- nrows;

    x11()
    p <- par(mfrow=c(nrows,ncols))

    for (ch in 1:nchannels) {

      image((1:nsamples)/Fs,freqs,t(tfrep[ch,,]),col=heat.colors(100),
            xlab="Secnods",ylab="Freqs (Hz)",
            main=channelnames[ch])
      
    }

    par(p)
    
##   if nargout > 1
##     figure(2);
##     for ch <- 1:nchannels
##       subplot(nrows,ncols,ch);
##       imagesc((1:nsamples)/Fs,freqs,squeeze(tfrepPhase(ch,:,:)));
##       axis xy;
##       if isempty(channelnames)
## 	ylabel(['Frequency Channel ' num2str(ch)]);
##       else
## 	ylabel(['Frequency ' channelnames{ch}]);
##       end
##       xlabel('Seconds');
##       drawnow;
##     end
##   end

  } #end graphics

  return (list(tfrep=tfrep, tfrepPhase=tfrepPhase))
}

######################################################################

morletLength <- function(Fs,f,width) {
  ##function len <- morletLength(Fs,f,width)
  dt <- 1/Fs
  sf <- f/width
  st <- 1/(2*pi*sf)
  len <- length(seq(-3.5*st,3.5*st,by=dt))
  return(len)
}

######################################################################

energyvec <- function(f,s,Fs,width) {
###function [y,phase] <- energyvec(f,s,Fs,width)
### function y <- energyvec(f,s,Fs,width)
###
### Return a vector containing the energy as a
### function of time for frequency f. The energy
### is calculated using Morlet's wavelets.
### s : signal
### Fs: sampling frequency
### width : width of Morlet wavelet (><- 5 suggested).
###
###

  dt <- 1/Fs
  sf <- f/width
  st <- 1/(2*pi*sf)

  t=seq(-3.5*st,3.5*st,by=dt)
  m <- morlet(f,t,width)
  yconv <- convolve(s,m,type="open")

  lengthMorlet <- length(m)
  firsthalf <- round(lengthMorlet/2)
  secondhalf <- lengthMorlet - firsthalf

  padtotal <- length(s)-length(yconv)
  padfront <- round(padtotal/2)
  padback <- padtotal - padfront

  yconvNoBoundary <- yconv[firsthalf:(length(yconv)-secondhalf)]

  ## #yconvNoBoundary <- [zeros(1,padfront) yconv( ...
  ## #   zeros(1,padback)];
  ## #[length(s) length(m) length(yconv) length(yconvNoBoundary) padfront padback  length(yconvNoBoundary) +padfront+ padback]

  ## #yconv <- yconv(ceil(lengthMorlet/2):end-floor(lengthMorlet/2));

  ## #y <- (2*abs(yconv)/Fs).^2;

  y <- abs(yconvNoBoundary)^2

  ##y <- y(ceil(length(m)/2):length(y)-floor(length(m)/2));
  ##y <- yconv(lengthMorlet:end-lengthMorlet);

  ##y <- log(y);

  ##phase <- unwrap(angle(yconv));
  ##if nargout > 1
  phase <- Arg(yconvNoBoundary)

  return (list(mag=y,phase=phase))
}


######################################################################
      
morlet <- function(f,t,width) {
  ## # function y <- morlet(f,t,width)
  ## #
  ## # Morlet's wavelet for frequency f and time t.
  ## # The wavelet will be normalized so the total energy is 1.
  ## # width defines the ``width'' of the wavelet.
  ## # A value ><- 5 is suggested.
  ## #
  ## # Ref: Tallon-Baudry et al., J. Neurosci. 15, 722-734 (1997), page 724
  ## #
  ## #
  ## # Ole Jensen, August 1998

  sf <- f/width
  st <- 1/(2*pi*sf)
  A <- 1/sqrt(st*sqrt(2*pi))
  y <- A*exp(-t^2/(2*st^2)) * exp(1i*2*pi*f*t)
  return(y)
}


######################################################################

convolve <-  function (x, y, conj = TRUE, type = c("circular", "open", "filter")) 
{
  type <- match.arg(type)
  n <- length(x)
  ny <- length(y)
  Real <- is.numeric(x) && is.numeric(y)
  if (type == "circular") {
    if (ny != n) 
      stop("length mismatch in convolution")
  }
  else {
    n1 <- ny - 1
    x <- c(rep.int(0, n1), x)
    if (n > 1)  ## i added this if
      insertz <- rep.int(0,n-1)
    else
      insertz <- NULL
    n <- length(y <- c(y, insertz))
  }
  x <- fft(fft(x) * (if (conj) Conj(fft(y))
                     else fft(y)), inv = TRUE)
  if (type == "filter") 
    (if (Real)  Re(x)
    else x)[-c(1:n1, (n - n1 + 1):n)]/n ## fix this too
  else (if (Real) Re(x)
        else x)/n

}

  
