cat("From makePassband.R:\n")
cat(" Sourcing main functions: makePassband, myfilter, and filterExample\n")
cat(" Sourcing secondary functions: chebbp2, localmax, convolve\n")

######################################################################

makePassband <- function(N,L,Fs,fstop1,fpass,fstop2) {
##   From http://www.dsp.rice.edu/software/fir.shtml
  if (missing(N)) {
    cat("B <- makePassband(N,L,Fs,fstop1,fpass,fstop2)\n")
    cat(" ## N is odd length of B, L is divisible by 4, Fs is sample rate\n")
    cat(" ## fstop1, fstop2 are limits of passband in Hz\n")
    cat(" ## fpass is Hz, between fstop1 and fstop2, where freq response is to be flat.\n")
    cat("Example use:\n")
    cat(" B<-makePassband(51,8,512,20,25,30);x<-runif(10000);A<-c(1);r<-myfilter(B,A,x);matplot(t(rbind(x,r$filtered)),type=\"l\")\n")
    return()
  }

  wp <- fpass/(Fs/2) * pi
  ws1 <- fstop1/(Fs/2) * pi
  ws2 <- fstop2/(Fs/2) * pi

  cat("ws1, wp, ws2 are",ws1,wp,ws2,"\n")

  return(chebbp2(N,L,wp,ws1,ws2))
}

######################################################################
	
myfilter <- function(B,A,x,state) {

  if (missing(B)) {
    cat("r <- myfilter(B,A,x,state) # A=c(1), B is row, x is matrix, time by column.  r$filtered, r$state\n")
    cat("Example use:\n")
    cat(" x<-runif(100);w<-c(1,0.2);B<-w/sum(w);A<-c(1);r<-myfilter(B,A,x);matplot(t(rbind(x,r$filtered)),type=\"l\")\n")
    cat(" x<-runif(100);w<-c(10,5,3,2,1);B<-w/sum(w);A<-c(1);r<-myfilter(B,A,x);matplot(t(rbind(x,r$filtered)),type=\"l\")\n")
    cat(" r2 <- myfilter(B,A,runif(100),r$state)\n")
    return()
  }
    
  if (A[1] != 1) {
    print('myfilter:  A(1) must be equal to 1');
    return()
  }

  nB <- length(B)
  nA <- length(A)
  if (!is.matrix(x))
    x <- matrix(x,nrow=1)
  
  nX <- ncol(x)
  nDim <- nrow(x)

  if (missing(state)) {
    state <- list(x = matrix(0,nDim,nB-1), y = matrix(0,nDim,nA-1))
  }

  state$x <- cbind(state$x, x)
  ncsx <- ncol(state$x)

  
  v <- B[1] * x
  cat("B[1] = ", B[1],"\n");
  cat("v[1,1] = ", v[1,1],"\n");
  if (nB > 1) { ## nX > 1) {
    for (i in 2:nB)
      {
      
        v <- v + B[i] * state$x[,(ncsx-i-nX+2):(ncsx-i+1)]
    }
    state$x <- state$x[,(ncsx-nB+2):ncsx,drop=FALSE]
  }

 ;
  ## The feedback part is intrinsically scalar,
  ## so this loop is where we spend a lot of time.

  state$y = cbind(state$y, v);  #second part is where new y's are accumulated  
  if (nA > 1) {
    Arev <- -rev(A[-1]) ##A[seq(nA,2,by=-1)]
    for (i in 1:nX)  # loop over input samples
      state$y[,nA+i-1] <- state$y[,nA+i-1] + state$y[,i:(i+nA-2)] * Arev
  }
  ncsy <- ncol(state$y)
  y <- state$y[,(ncsy-nX+1):ncsy]

  inx <<- x;
  inv <<- v;
  insty <<- state$y;
  iny <<- y;
  if (nA > 1)
    state$y <- state$y[,(ncsy-nA+2):ncsy]
  else
    state$y <- NULL
  return(list(filtered=y, state=state))
}

######################################################################

chebbp2 <- function(N,L,wp,ws1,ws2) {

  ##function [h,h2,rs,del] <- chebbp2(N,L,wp,ws1,ws2)
  ## h <- chebbp2(N,L,wp,ws1,ws2)
## A second program for the design of symmetric bandpass FIR filters with 
## flat monotonically decreasing passbands (on either side of wp)
## and equiripple stopbands. This program is similar to chebbp.m,
## but it uses a different set of input parameters.
##
## output
##  h  : filter
## input
##  N   : length of total filter
##  L   : degree of flatness
##  wp  : passband frequency of flatness 
##  ws1 : first stopband edge
##  ws2 : second stopband edge
##  Need: 0 < ws1 < wp < ws2 < pi
##
## Author: Ivan W. Selesnick, Rice University
##
## # EXAMPLE
##    N  <-  55
##    L  <-  8
##    wp  <- 0.4*pi
##    ws1 <- 0.3*pi
##    ws2 <- 0.6*pi
##    [h,h2,rs,del] <- chebbp2(N,L,wp,ws1,ws2)
#
## Reference:
## "Exchange Algorithms for the Design of Linear Phase FIR Filters 
## and Differentiators Having Flat Monotonic Passbands and Equiripple 
## Stopbands" by I. W. Selesnick and C. S. Burrus, 
  ## IEEE Trans. on Cicuits and Systems II, 43(9):671-675, Sept 1996

  if ((N %% 2 == 0) || (L %% 4 != 0)) {
    cat("N must be odd and L must be divisible by 4\n")
    return()
  } else if ((0 >= ws1) || (ws1 >= wp) || (wp >= ws2) || (ws2 >= pi)) {
    cat("need : 0 < ws1 < wp < ws2 < pi\n")
    return()
  } else if (L<1) {
    cat("L must be positive\n")
    return()
  }

  q  <- (N-L+1)/2                       # number of filter parameters
                                        # num. of ref. set frequencies <- q + 1

  g <- 2^ceiling(log2(8*N))       # number of grid points
  SN <- 1e-8                   # SN : SMALL NUMBER
  w <- t(0:g)* pi / g

  d <- ws1/(pi-ws2)		# q1 : number of ref. set freq. in 1st stopband
  q1 <- round((q+1)/(1+1/d))	# q2 : number of ref. set freq. in 2nd stopband
  if (q1 == 0)
    q1 <- 1
  else if (q1 == q+1)
    q1 <- q

  q2 <- q + 1 - q1	

  if (q1 == 1)
    rs1 <- ws1
  else
    rs1 <- t(0:(q1-1)) * (ws1/(q1-1))

  if (q2 == 1)
    rs2 <- ws2
  else
    rs2 <- t(0:(q2-1)) * (pi-ws2)/(q2-1) + ws2

  rs <- matrix(c(rs1, rs2))


  Z <- matrix(0,2*(g+1-q)-1,1)
  A1 <- (-1)^(L/2) * (sin(w/2-wp/2) * sin(w/2+wp/2)) ^(L/2)


  si <- (-1)^matrix(0:q)
  n <- matrix(0:(q-1),nrow=1)
  A1r <- (-1)^(L/2) * (sin(rs/2-wp/2) * sin(rs/2+wp/2))^(L/2)
  it <- 0


  while (it < 15) {
    
    x <- solve(cbind(cos(rs %*% n), si/A1r),1/A1r)


    a <- matrix(-x[1:q])
    del <- x[q+1]

    if (q > 2) {
      secondcomp <- a[2:q]/2
      lastcomp <- a[seq(q,2,by=-1)]/2
    } else {
      secondcomp <- NULL
      lastcomp <- NULL
    }


	b <- matrix(c(a[1],secondcomp,Z,lastcomp));


    A2 <- Re(fft(b))

    A2 <- A2[1:(g+1)]

   
    A  <- 1 + A1 * A2
    Y  <- si*del



    ri <- matrix(sort(c(localmax(A), localmax(-A))))
	
    lri <- length(ri)
    if (length(ri) != q+1) {
      if (abs(A[ri[lri]]-A[ri[lri-1]]) < abs(A[ri[1]]-A[ri[2]]))
        ri <- ri[-lri,1,drop=FALSE]
      else
        ri <- ri[-1,1,drop=FALSE]
    }
   
    rs <- (ri-1)*pi/g
   
    k <- which.min(abs(rs - wp))

    
    rs <- rs[-k,1,drop=FALSE]
   
    Aws1 <- 1 + (cos(ws1*n) %*% a) * ((-1)^(L/2) %*% (sin(ws1/2-wp/2)*sin(ws1/2+wp/2))^(L/2))
  
    Aws2 <- 1 + (cos(ws2*n) %*% a)*((-1)^(L/2) %*% (sin(ws2/2-wp/2)*sin(ws2/2+wp/2))^(L/2))

 
    if ((Aws1 > Aws2) || any((rs > wp) && (rs < ws2)))
      rs <- sort(c(ws1, rs))
    else
      rs <- sort(c(ws2, rs))

   
    
    A1r <- (-1)^(L/2) * (sin(rs/2-wp/2)*sin(rs/2+wp/2))^(L/2)

    Ar <- 1 + (cos(rs%*%n) %*% a) * A1r

    Err <- max(c(max(Ar)-abs(del), abs(del)-abs(min(Ar))))
    cat("    Err is ",Err,"\n")
    if (Err < SN) {
      cat("\n    I have converged \n")
      break
    }

    it <- it + 1
  }

	
  if (q > 2) 
    h2 <- c(a[seq(q,2,by=-1)]/2, a[1], a[2:q]/2)
  else
    h2 <- a[1]


  h <- matrix(h2)
y <- c(1,-2*cos(wp), 1);
print(y);
  for (k in 1:(L/2)) {

    h <- convolve(h,y,type="open")/4
  }
  h[(N+1)/2] <- h[(N+1)/2] + 1

  return(h)
}
             
######################################################################

localmax <- function(x) {
  x <- matrix(x)
  N <- length(x)
  b1 <- x[-N] <= x[-1]
  b2 <- x[-N] > x[-1]
  k <- which(b1[1:(N-2)]  & b2[2:(N-1)]) + 1

  #print("in localmax")
  #print(k)
  if (x[1] > x[2])
    k <- c(k,1)
  if (x[N] > x[N-1])
    k <- c(k,N)

  k <- sort(k)
  #print("localmax")
  #print(k)

  return(k)
}

######################################################################

convolve <-  function (x, y, conj = TRUE, type = c("circular", "open", "filter")) 
{
  type <- match.arg(type)
  n <- length(x)
  ny <- length(y)
  Real <- is.numeric(x) && is.numeric(y)
  if (type == "circular") {
    if (ny != n) 
      stop("length mismatch in convolution")
  }
  else {
    n1 <- ny - 1
    x <- c(rep.int(0, n1), x)

    if (n > 1)  ## i added this if
      insertz <- rep.int(0,n-1)
    else
      insertz <- NULL
    n <- length(y <- c(y, insertz))
  };
  x <- fft(fft(x) * (if (conj) Conj(fft(y))
                     else fft(y)), inv = TRUE)

  if (type == "filter") 
    (if (Real)  Re(x)
    else x)[-c(1:n1, (n - n1 + 1):n)]/n ## fix this too
  else (if (Real) Re(x)
        else x)/n

}

