/*
* CEBL : CSU EEG Brain-Computer Interface Lab
*
* Author: Jeshua Bratman - jeshuabratman@gmail.com
*
* This file is part of CEBL.
*
* CEBL is free software; you can redistribute it and/or modify it.
* We only ask that if you use our code that you cite the source in
* your project or publication.
*
* EEG Group (www.cs.colostate.edu/eeg)
* Department of Computer Science
* Colorado State University
* 
*/

/*! \
 * class MNF
 * \author Jeshua Bratman 
 * 
 * MNF filter for EEG signals.
 */

#ifndef FILTERMNF_H
#define FILTERMNF_H

#include "model/Filter.hpp"

namespace CEBL
{
  class MNF : public Filter
  {
  private:
    void mnf(const ublas::matrix<double> &);
    ublas::matrix<double> psi;
    ublas::matrix<double> phi;
    ublas::matrix<double> filter;
    ublas::vector<double> means;




  public:
    MNF() { plugin_name = "MNF"; }

    /*! Using a matrix of sample data and vector of components to remove,
      create the internal filter matrix which will be used by the apply
      function to remove components from new data.
      \param data sample data nFeatures X nSamples
      \param components vector of component indices
    */
    void make(const ublas::matrix<double> &data,
              const std::vector<int> &components);

    /*! Apply filter matrix to new data and return filtered result.

      TODO: make a version which modifies input in-place
      \param data data to filter
      
      \return filtered result matrix, same size as data
    */
    ublas::matrix<double> apply(const ublas::matrix<double> & data) const;

    /*! Extract components from sample data for manual or automatic artifact
      identification. 
      \param data sample data nFeatures X nSamples

      \return matrix of components
    */
    ublas::matrix<double> extract(const ublas::matrix<double> &data);

    /*! Returns the internal filter matrix created in the make function.
      
      \return 
    */
    ublas::matrix<double> getFilterMatrix() { return filter; }

    //saving and loading
    map<string, SerializedObject> save() const;
    void load(map<string, SerializedObject> objects);

  };
}


#endif
