#include "CEBLModel.hpp"
#include <cppR.hpp>

int main(int ac, char ** av)
{
  CEBLModel * model = new CEBLModel;

  //add a data file preference to the command line options
  model->preferencesAddOption("datafile",
                              "Training data file to test QDA with.");

  model->InitModel(ac,av);

  if(model->initializedSuccessfully())
    {
      //--------------------------------------------------

      // check the filename parameter
      string data_filename = model->preferencesGetOption("datafile");
      if(data_filename == "None")
        {
          cerr << "usage: test_qda --datafile=<training data filename>\n";
          return 1;
        }

      // load the data file
      EEGTrainingData data;
      try
        {
          data = model->dataLoadTrainingDataFile(data_filename);
        }
      catch(exception &e)
        {
          cerr << "Failed to load datafile: " << e.what() << "\n";
          return 1;
        }

      // select QDA classifier
      model->classifiersSetSelected("QDA");

      //select lag feature
      model->featuresSetSelected("Lag");
      std::map<std::string, CEBL::Param> params = model->featureGetParams();
      params[0].setInt(5);
      model->featureSetParams(params);

      //featurize data
      data = model->featuresExtract(data);

      // select first sequence as training and second as testing
      EEGTrainingData train;
      EEGTrainingData test;
      for(int i=0;i<data.numClasses();i++)
        {
          train.set(i,0,data.get(i,0));
          test.set(i,0,data.get(i,1));
        }

      // train classifier
      model->classifierTrain(train);

      // use classifier
      EEGData test_data = test.collapse();
      ublas::vector<int> targets =  test.getTargets();
      ublas::vector<int> predicted = model->classifierUse(test_data);

      double correct = 0;
      for(unsigned i=0;i<targets.size();i++)
        {
          if(targets[i] == predicted[i])
            correct++;
        }
      cout << (correct/targets.size() * 100.0) << "% correct\n";
      
      //--------------------------------------------------

    }
  delete model;
  return 0;
}
