#include "model/RController.hpp"
#include <cppR/cppR.hpp>
#include <unistd.h>
#include <iostream>
using namespace std;
using namespace cppR;

int main(int argc, char *argv[])
{
  CEBL::RController R;
  R.start();
  ublas::matrix<double> X = createMatrix(runif<double>(19*1000),19,1000);
  R.writeMatrixToTempFile(X);

  R.sendCommand("m = as.matrix(read.table(file='%f'))");
  cout << R.getResponse();
  R.sendCommand("dim(m)");
  cout << R.getResponse();
  R.sendCommand("x11();plot(m)");
  cout << R.getResponse();

  sleep(5);
  R.stop();

}
