(define (domain psr)
  (:requirements :adl)
  (:types DEVICE SIDE LINE)
  (:constants side1 side2 - SIDE earth - DEVICE)
  (:predicates (ext ?l - LINE ?x - DEVICE ?s - SIDE)
               (breaker ?x - DEVICE)
               (closed ?x - DEVICE)
               (faulty ?l - LINE)
               (con ?x - DEVICE ?sx - SIDE ?y - DEVICE ?sy - SIDE)

               (upstream ?x - DEVICE ?sx - SIDE ?y - DEVICE ?sy - SIDE)
               (unsafe ?x - DEVICE ?sx - SIDE)
               (affected ?x - DEVICE)
               (fed ?l - LINE)
               (fixed)
               (done)
               (new))

  (:action axiom
    :parameters ()
    :precondition (not (fixed))
    :effect 
       (and (done)
	    (forall (?x - DEVICE)
               (forall (?sx - SIDE)
		  (forall (?y - DEVICE)
                     (forall (?sy - SIDE)
                        (when (and (not (upstream ?x ?sx ?y ?sy))
                                   (closed ?x)
                                   (or (and (= ?sx side1) (con ?x side2 ?y ?sy))
                                       (and (= ?sx side2) (con ?x side1 ?y ?sy))
                                       (exists (?z - DEVICE)
		                          (and (closed ?z)
                                               (or (and (con ?z side1 ?y ?sy)
                                                        (upstream ?x ?sx ?z side2))
                                                   (and (con ?z side2 ?y ?sy)
                                                       (upstream ?x ?sx ?z side1)))))))
		                   (and (upstream ?x ?sx ?y ?sy)
			                (new)))))))
           (forall (?x - DEVICE)
              (forall (?sx - SIDE)
                 (when (and (not (unsafe ?x ?sx))
                            (closed ?x)
                            (or (and (= ?sx side1)
                                     (exists (?l - LINE)
                                        (and (ext ?l ?x side2)
                                             (or (faulty ?l)
                                                 (exists (?y - DEVICE)
                                                    (exists (?sy - SIDE)
                                                        (and (con ?x side2 ?y ?sy)
                                                             (unsafe ?y ?sy))))))))
                                (and (= ?sx side2)
                                     (exists (?l - LINE)
                                        (and (ext ?l ?x side1)
                                             (or (faulty ?l)
                                                 (exists (?y - DEVICE)
                                                    (exists (?sy - SIDE)
                                                       (and (con ?x side1 ?y ?sy)
                                                            (unsafe ?y ?sy))))))))))
                      (and (unsafe ?x ?sx)
                           (new)))))
           (forall (?x - DEVICE)
              (when (and (not (affected ?x))
                         (breaker ?x)
                         (exists (?sx - SIDE) (unsafe ?x ?sx)))
	 	    (and (affected ?x)
                         (new))))
           (forall (?l - LINE)
              (when (and (not (fed ?l))
                         (exists (?x - DEVICE) 
                            (and (closed ?x) 
                                 (or (and (ext ?l ?x side1) 
                                          (or (breaker ?x)
                                              (exists (?y - DEVICE)
                                                 (exists (?sy - SIDE)
                                                    (and (breaker ?y)
                                                         (upstream ?y ?sy ?x side2))))))
                                     (and (ext ?l ?x side2) 
                                          (or (breaker ?x)
                                              (exists (?y - DEVICE)
                                                 (exists (?sy - SIDE)
                                                    (and (breaker ?y)
                                                         (upstream ?y ?sy ?x side1))))))))))
                    (and (fed ?l)
 		         (new))))))

  (:action fixpoint
    :parameters ()
    :precondition (done)
    :effect (and (when (not (new)) (fixed))
                 (not (new))
                 (not (done))))

  (:action open
    :parameters (?c - DEVICE)
    :precondition (and (not (= ?c earth))
		       (closed ?c) 
                       (forall (?b - DEVICE) (not (affected ?b)))
                       (fixed))
    :effect (and (not (closed ?c))
                 (not (fixed))
                 (not(done))
                 (forall (?x - DEVICE)
	           (forall (?sx - SIDE)
		      (forall (?y - DEVICE)
			 (forall (?sy - SIDE)
                            (not (upstream ?x ?sx ?y ?sy))))))
                 (forall (?x - DEVICE) 
	            (forall (?sx - SIDE)
                      (not (unsafe ?x ?sx))))
		 (forall (?x - DEVICE) (not (affected ?x)))
                 (forall (?l - LINE)
			 (not (fed ?l)))))

  (:action close
    :parameters  (?c - DEVICE)
    :precondition (and (not (= ?c earth))
		       (not (closed ?c))
                       (forall (?b - DEVICE) (not (affected ?b)))
                       (fixed))
    :effect (and (closed ?c)
                 (not(fixed))
                 (not(done)) 
                 (forall (?x - DEVICE)
	           (forall (?sx - SIDE)
		      (forall (?y - DEVICE)
			 (forall (?sy - SIDE)
                            (not (upstream ?x ?sx ?y ?sy))))))
                 (forall (?x - DEVICE) 
	            (forall (?sx - SIDE)
                      (not (unsafe ?x ?sx))))
		(forall (?x - DEVICE) (not (affected ?x)))
                (forall (?l - LINE)
			(not (fed ?l)))))

  (:action wait
    :parameters  ()
    :precondition (and (exists (?b - DEVICE) (affected ?b)) (fixed))
    :effect (and (forall (?b - DEVICE) (when (affected ?b) (not (closed ?b))))
                 (not(fixed))
                 (not(done)) 
                 (forall (?x - DEVICE)
	           (forall (?sx - SIDE)
		      (forall (?y - DEVICE)
			 (forall (?sy - SIDE)
                            (not (upstream ?x ?sx ?y ?sy))))))
                 (forall (?x - DEVICE) 
	            (forall (?sx - SIDE)
                      (not (unsafe ?x ?sx))))
		(forall (?x - DEVICE) (not (affected ?x)))
                (forall (?l - LINE)
			(not (fed ?l)))))
)
