import System(getArgs)
import Numeric.LinearAlgebra
import Data.Time.Clock
import System.Random
import Numeric
import Data.List(foldl')

randomMatrix :: Int -> (Int, Int) -> Matrix Double
randomMatrix seed (nrow,ncol) = 
    reshape ncol $ fromList $ take (ncol*nrow) $ randomRs (0,1) $ mkStdGen seed

main = do
  args <- getArgs
  let [nTimes, nRows] = (map read args) :: [Int]
  let m = 0.001 * randomMatrix 100 (nRows,nRows)
  print $ m @@> (1,1)  -- to force evaluation of m before start of timing.
  start <- getCurrentTime
  --let mm = foldl (<>) m (replicate nTimes m)
  --let mm = foldl (\z m' -> z <> m') m (replicate 50 m)
  --let mm = foldl1' (<>)(replicate 51 m)
  let mm = foldl' (<>) m (replicate nTimes m)
  print $ mm @@> (1,1)
  end <- getCurrentTime
  let delta = diffUTCTime end start
  putStrLn $ "---------------------------------------------------Haskell--- " ++ 
               (show nTimes) ++ " " ++ (show nRows) ++ " " ++ (show delta )
