prog = ReadAlphabets("examples/smith_waterman.ab");
system = "smith_waterman";
outDir = "test-out/"+system;
AShow(prog);
CheckProgram(prog);
#PrintAST(prog);

setSpaceTimeMap(prog, system, "H", "(i,j->i+j,j)");
setDimensionType(prog, system, "H", 0, "S");
setDimensionType(prog, system, "H", 1, "S");
setSpaceTimeMap(prog, system, "score", "(i,j->i+j-2,j)");
setDimensionType(prog, system, "score", 0, "S");
setDimensionType(prog, system, "score", 1, "S");
setMemoryMap(prog, system, "score", "score", "(i,j->)");

VerifyTargetMapping(prog, system, "MIN");

#options = createTiledCGOptionForScheduledC();
#setTiledCGOptionOptimize(options, 1);

generateScheduledCode(prog, system, outDir);
generateWrapper(prog, system, outDir);
generateMakefile(prog, system, outDir);
