/******************************************************************************
*
* Code For HW1 in the CS560/Spring2012 Course 
* Code is based on the SciMark2 Numeric Benchmark, 
* see http://math.nist.gov/scimark
* Modified by Manaf Gharaibeh and Michelle Strout (Jan-29, 2012) 
* to enable reading the sparse matrix in from a file and put all 
* code into one file.
* 
*******************************************************************************/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <omp.h>

#include "mmio.h"


void print_banner(void);
void readSparseMatrix(double **val, int **row, int **col, int *N, int *M, 
                      char *fname);

int main(int argc, char *argv[])
{
        char* filename;
        
        /* run the benchmark */
        if (argc > 1)
        {
            int current_arg = 1;

            if (strcmp(argv[1], "-help")==0  || strcmp(argv[1], "-h") == 0)
            {
                fprintf(stderr, "Usage: [-fname filename]\n"); 
                exit(0);
            }

            if (strcmp(argv[1], "-fname")==0)
            {
                filename = argv[2];
                current_arg+=2;
            }
              
        } else {
            fprintf(stderr, "Usage: [-fname filename]\n"); 
            exit(0);
        }

        print_banner();

        //************ read Sparse_size_M, Sparse_size_nz from input file
        double* val;
        int* row;
        int* col;
        int nrow, ncol;
        readSparseMatrix(&val, &row, &col, &nrow, &ncol, filename);
        
        // initialize x and y
        double *x = (double*) malloc(sizeof(double)*(ncol));
        int j;
        for (j=0; j<ncol; j++) {
            x[j] = 3;
        }
        double *y = (double*) malloc(sizeof(double)*(nrow));

        //************ compute SpMV in a loop
        int reps = 1000;
        double t0,t1,t2,elapsed_time;

        t0 = omp_get_wtime();
        t1 = omp_get_wtime();

        int i, r, p;
        for (r=0; r<reps; r++) {
            for (i=0; i<nrow; i++) {
                double sum = 0.0;
                int rowR = row[i];
                int rowRp1 = row[i+1];
                for (p=rowR; p<rowRp1; p++) {
                    sum += x[ col[p] ] * val[p];
                }
                y[i] = sum;
            }
        }

        t2 = omp_get_wtime();
        elapsed_time = t0 + t2 - 2 * t1;
        printf("Elapsed Time: %f\n", elapsed_time);

        //************ print out the resulting y array
        char* outfile = "y.out";
        printf("y array printed to %s\n", outfile);
        FILE *out = fopen(outfile,"w");
        for (i=0; i<nrow; i++) {
            fprintf(out, "%lf\n", y[i]);
        }
        fclose(out);
        
        return 0;
  
}

void print_banner()
{
 printf("**                                                              **\n");
 printf("** This code is a modification for the SciMark2 Numeric Benchmark, see http://math.nist.gov/scimark **\n");
 printf("**                                                              **\n");
}



//read sparse matrix from an input file and represent it with CSR storage format
//The output of this routine is that val, row, and col now point at
//the CSR representation for the sparse matrix in fname.
//val, row, and col are allocated in here.
void readSparseMatrix(double **val, int **row, int **col, int *N, int *M, 
                      char *fname)
{
    FILE *fp;
    fp = fopen(fname, "r");
  
    if(fp == NULL)
    {
        fprintf(stderr,"Cannot open file for reading");
        exit(EXIT_FAILURE);
    }

    //Read number of rows and colomns and non zero elements
    int nrow, ncol, nz;
    // get MM info 
    MM_typecode matcode;
    if (mm_read_banner(fp, &matcode) != 0)
    {
        fprintf(stderr,"Could not process Matrix Market banner.\n");
        exit(1);
    }
    /* find out size of sparse matrix .... */
    mm_read_mtx_crd_size(fp, &nrow, &ncol, &nz);
    printf("matrix dimension from scimark2.c >>> %d %d %d\n", nrow, ncol, nz);

    *N = nrow;
    *M = ncol;
    
    //Initialize the val, col, and row arrays
    (*row) = (int*) calloc((nrow+1),sizeof(int));
    (*col) = (int*) malloc(sizeof(int)*(nz));
    (*val) = (double*) malloc(sizeof(double)*(nz));
    
    int i = 0;
    int c,r;
    double v;
    // loop through col\trow\tval entries in file 
    // do conversion from 1-index to 0-index 
    while (fscanf(fp, "%d %d %lf\n", &r, &c, &v)!=EOF) {
        (*val)[i]=v;
        (*col)[i]=c-1;
        (*row)[r-1]=(*row)[r-1]+1; 
        //row[] must be initialized to zeros initially
        i+=1;       
     }
    
    if(fclose(fp) != 0) {
        fprintf(stderr,"Could not close file properly!\n");
        exit(EXIT_FAILURE);
    }


    // Accumulate results in row. If we have row initially= 2 1 0 1 
    // it will become 0 2 3 3 4
    int temp1 = (*row)[0];
    int temp2 = (*row)[1];
    (*row)[0] = 0;
    (*row)[1] = temp1;

    for (i = 2; i <= nrow; i++){
        temp1=temp2;
        temp2=(*row)[i];
        (*row)[i]=(*row)[i-1]+temp1;
    }
    //check that everything worked
    if ((*row)[nrow] != nz) {
        fprintf(stderr,"nz != row[nrow]!\n");
        exit(EXIT_FAILURE);
    }

}


