/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.classify;

import LBJ2.classify.Feature;
import LBJ2.classify.FeatureVector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.LinkedList;

public abstract class Classifier
implements Cloneable,
Serializable {
    public String containingPackage;
    public String name;

    public static double test(Classifier classifier, Classifier classifier2, Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!classifier.classify(objectArray[i]).valueEquals(classifier2.classify(objectArray[i]))) continue;
            ++n;
        }
        return (double)n / (double)objectArray.length;
    }

    protected Classifier() {
    }

    protected Classifier(String string) {
        int n = string.lastIndexOf(46);
        this.containingPackage = n == -1 ? "" : string.substring(0, n);
        this.containingPackage = this.containingPackage.intern();
        this.name = string.substring(n + 1).intern();
    }

    public abstract FeatureVector classify(Object var1);

    public FeatureVector[] classify(Object[] objectArray) {
        FeatureVector[] featureVectorArray = new FeatureVector[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            featureVectorArray[i] = this.classify(objectArray[i]);
        }
        return featureVectorArray;
    }

    public String getInputType() {
        return "java.lang.Object";
    }

    public String getOutputType() {
        return "discrete";
    }

    public String[] allowableValues() {
        return new String[0];
    }

    public short valueIndexOf(String string) {
        int n;
        String[] stringArray = this.allowableValues();
        for (n = 0; n < stringArray.length && !stringArray[n].equals(string); n = (short)(n + 1)) {
        }
        return (short)(n == stringArray.length ? -1 : n);
    }

    public Feature featureValue(Object object) {
        throw new UnsupportedOperationException("The featureValue(Object) method has not been overridden in class '" + this.getClass().getName() + "'.");
    }

    public String discreteValue(Object object) {
        throw new UnsupportedOperationException("The discreteValue(Object) method has not been overridden in class '" + this.getClass().getName() + "'.");
    }

    public double realValue(Object object) {
        throw new UnsupportedOperationException("The realValue(Object) method has not been overridden in class '" + this.getClass().getName() + "'.");
    }

    public String[] discreteValueArray(Object object) {
        throw new UnsupportedOperationException("The discreteValueArray(Object) method has not been overridden in class '" + this.getClass().getName() + "'.");
    }

    public double[] realValueArray(Object object) {
        throw new UnsupportedOperationException("The realValueArray(Object) method has not been overridden in class '" + this.getClass().getName() + "'.");
    }

    public LinkedList getCompositeChildren() {
        throw new UnsupportedOperationException("The getCompositeChildren() method has not been overridden in class '" + this.getClass().getName() + "'.");
    }

    public String toString() {
        return this.name;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            System.err.println("Error cloning " + this.getClass().getName() + ":");
            exception.printStackTrace();
            System.exit(1);
        }
        return object;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.containingPackage = this.containingPackage.intern();
    }
}

