/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.classify;

import LBJ2.classify.DiscreteArrayStringFeature;
import LBJ2.classify.DiscretePrimitiveFeature;
import LBJ2.classify.Feature;
import LBJ2.classify.RealArrayFeature;
import LBJ2.classify.RealFeature;
import LBJ2.learn.Lexicon;
import LBJ2.util.ByteString;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;

public class DiscreteArrayFeature
extends DiscretePrimitiveFeature {
    protected int arrayIndex;
    protected int arrayLength;

    protected DiscreteArrayFeature() {
    }

    public DiscreteArrayFeature(String string, String string2, ByteString byteString, ByteString byteString2, int n, int n2) {
        this(string, string2, byteString, byteString2, -1, 0, n, n2);
    }

    public DiscreteArrayFeature(String string, String string2, ByteString byteString, ByteString byteString2, short s, short s2, int n, int n2) {
        super(string, string2, byteString, byteString2, s, s2);
        this.arrayIndex = n;
        this.arrayLength = n2;
    }

    public int getArrayIndex() {
        return this.arrayIndex;
    }

    public int getArrayLength() {
        return this.arrayLength;
    }

    public boolean fromArray() {
        return true;
    }

    public void setArrayLength(int n) {
        this.arrayLength = n;
    }

    public Feature getFeatureKey(Lexicon lexicon, boolean bl, int n) {
        if (this.totalValues() == 2) {
            return new DiscreteArrayFeature(this.containingPackage, this.generatingClassifier, this.identifier, ByteString.emptyString, -1, 2, this.getArrayIndex(), 0);
        }
        return this;
    }

    public RealFeature makeReal() {
        if (this.totalValues == 2) {
            return new RealArrayFeature(this.containingPackage, this.generatingClassifier, this.identifier, this.valueIndex, this.arrayIndex, this.arrayLength);
        }
        ByteString byteString = (ByteString)this.identifier.clone();
        ByteString[] byteStringArray = new ByteString[]{new ByteString("_", byteString.getEncoding()), this.value};
        byteString.append(byteStringArray);
        return new RealArrayFeature(this.containingPackage, this.generatingClassifier, byteString, 1.0, this.arrayIndex, this.arrayLength);
    }

    public Feature withStrength(double d) {
        if (this.totalValues != 2 || d != 0.0 && d != 1.0) {
            return null;
        }
        return new DiscreteArrayFeature(this.containingPackage, this.generatingClassifier, this.identifier, ByteString.emptyString, (short)Math.round(d), 2, this.arrayIndex, this.arrayLength);
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.arrayIndex;
    }

    public boolean equals(Object object) {
        return super.equals(object) && (object instanceof DiscreteArrayFeature ? this.arrayIndex == ((DiscreteArrayFeature)object).arrayIndex : this.arrayIndex == ((DiscreteArrayStringFeature)object).arrayIndex);
    }

    public boolean classEquivalent(Feature feature) {
        return feature instanceof DiscreteArrayStringFeature;
    }

    public int compareTo(Object object) {
        int n = this.compareNameStrings(object);
        if (n != 0) {
            return n;
        }
        DiscreteArrayFeature discreteArrayFeature = (DiscreteArrayFeature)object;
        n = this.identifier.compareTo(discreteArrayFeature.identifier);
        if (n != 0) {
            return n;
        }
        n = this.arrayIndex - discreteArrayFeature.arrayIndex;
        if (n != 0) {
            return n;
        }
        return this.value.compareTo(discreteArrayFeature.value);
    }

    public void write(StringBuffer stringBuffer) {
        this.writeNameString(stringBuffer);
        stringBuffer.append("[");
        stringBuffer.append(this.arrayIndex);
        stringBuffer.append("](");
        stringBuffer.append(this.value.toString());
        stringBuffer.append(")");
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeInt(this.arrayIndex);
        exceptionlessOutputStream.writeInt(this.arrayLength);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.arrayIndex = exceptionlessInputStream.readInt();
        this.arrayLength = exceptionlessInputStream.readInt();
    }

    public String lexWrite(ExceptionlessOutputStream exceptionlessOutputStream, Lexicon lexicon, String string, String string2, String string3, String string4, ByteString byteString) {
        String string5 = super.lexWrite(exceptionlessOutputStream, lexicon, string, string2, string3, string4, byteString);
        exceptionlessOutputStream.writeInt(this.arrayIndex);
        exceptionlessOutputStream.writeInt(this.arrayLength);
        return string5;
    }

    public void lexRead(ExceptionlessInputStream exceptionlessInputStream, Lexicon lexicon, String string, String string2, String string3, ByteString byteString) {
        super.lexRead(exceptionlessInputStream, lexicon, string, string2, string3, byteString);
        this.arrayIndex = exceptionlessInputStream.readInt();
        this.arrayLength = exceptionlessInputStream.readInt();
    }
}

