/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.classify;

import LBJ2.classify.DiscreteArrayFeature;
import LBJ2.classify.DiscretePrimitiveStringFeature;
import LBJ2.classify.Feature;
import LBJ2.classify.RealArrayStringFeature;
import LBJ2.classify.RealFeature;
import LBJ2.learn.Lexicon;
import LBJ2.util.ByteString;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;

public class DiscreteArrayStringFeature
extends DiscretePrimitiveStringFeature {
    protected int arrayIndex;
    protected int arrayLength;

    protected DiscreteArrayStringFeature() {
    }

    public DiscreteArrayStringFeature(String string, String string2, String string3, String string4, int n, int n2) {
        this(string, string2, string3, string4, -1, 0, n, n2);
    }

    public DiscreteArrayStringFeature(String string, String string2, String string3, String string4, short s, short s2, int n, int n2) {
        super(string, string2, string3, string4, s, s2);
        this.arrayIndex = n;
        this.arrayLength = n2;
    }

    public int getArrayIndex() {
        return this.arrayIndex;
    }

    public int getArrayLength() {
        return this.arrayLength;
    }

    public boolean fromArray() {
        return true;
    }

    public void setArrayLength(int n) {
        this.arrayLength = n;
    }

    public Feature getFeatureKey(Lexicon lexicon, boolean bl, int n) {
        if (this.totalValues() == 2) {
            return new DiscreteArrayStringFeature(this.containingPackage, this.generatingClassifier, this.identifier, "", -1, 2, this.getArrayIndex(), 0);
        }
        return this;
    }

    public RealFeature makeReal() {
        if (this.totalValues == 2) {
            return new RealArrayStringFeature(this.containingPackage, this.generatingClassifier, this.identifier, this.valueIndex, this.arrayIndex, this.arrayLength);
        }
        StringBuffer stringBuffer = new StringBuffer(this.identifier);
        stringBuffer.append('_');
        stringBuffer.append(this.value);
        return new RealArrayStringFeature(this.containingPackage, this.generatingClassifier, stringBuffer.toString(), 1.0, this.arrayIndex, this.arrayLength);
    }

    public Feature withStrength(double d) {
        if (this.totalValues != 2 || d != 0.0 && d != 1.0) {
            return null;
        }
        return new DiscreteArrayStringFeature(this.containingPackage, this.generatingClassifier, this.identifier, "", (short)Math.round(d), 2, this.arrayIndex, this.arrayLength);
    }

    public Feature encode(String string) {
        if (string == null || string == "String") {
            return this;
        }
        ByteString byteString = this.identifier.length() == 0 ? ByteString.emptyString : new ByteString(this.identifier, string);
        return new DiscreteArrayFeature(this.containingPackage, this.generatingClassifier, byteString, new ByteString(this.value, string), this.valueIndex, this.totalValues, this.arrayIndex, this.arrayLength);
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.arrayIndex;
    }

    public boolean equals(Object object) {
        return super.equals(object) && (object instanceof DiscreteArrayStringFeature ? this.arrayIndex == ((DiscreteArrayStringFeature)object).arrayIndex : this.arrayIndex == ((DiscreteArrayFeature)object).arrayIndex);
    }

    public boolean classEquivalent(Feature feature) {
        return feature instanceof DiscreteArrayFeature;
    }

    public int compareTo(Object object) {
        int n = this.compareNameStrings(object);
        if (n != 0) {
            return n;
        }
        DiscreteArrayStringFeature discreteArrayStringFeature = (DiscreteArrayStringFeature)object;
        n = this.identifier.compareTo(discreteArrayStringFeature.identifier);
        if (n != 0) {
            return n;
        }
        n = this.arrayIndex - discreteArrayStringFeature.arrayIndex;
        if (n != 0) {
            return n;
        }
        return this.value.compareTo(discreteArrayStringFeature.value);
    }

    public void write(StringBuffer stringBuffer) {
        this.writeNameString(stringBuffer);
        stringBuffer.append("[");
        stringBuffer.append(this.arrayIndex);
        stringBuffer.append("](");
        stringBuffer.append(this.value);
        stringBuffer.append(")");
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        exceptionlessOutputStream.writeInt(this.arrayIndex);
        exceptionlessOutputStream.writeInt(this.arrayLength);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.arrayIndex = exceptionlessInputStream.readInt();
        this.arrayLength = exceptionlessInputStream.readInt();
    }

    public String lexWrite(ExceptionlessOutputStream exceptionlessOutputStream, Lexicon lexicon, String string, String string2, String string3, String string4, ByteString byteString) {
        String string5 = super.lexWrite(exceptionlessOutputStream, lexicon, string, string2, string3, string4, byteString);
        exceptionlessOutputStream.writeInt(this.arrayIndex);
        exceptionlessOutputStream.writeInt(this.arrayLength);
        return string5;
    }

    public void lexRead(ExceptionlessInputStream exceptionlessInputStream, Lexicon lexicon, String string, String string2, String string3, ByteString byteString) {
        super.lexRead(exceptionlessInputStream, lexicon, string, string2, string3, byteString);
        this.arrayIndex = exceptionlessInputStream.readInt();
        this.arrayLength = exceptionlessInputStream.readInt();
    }
}

