/*
 * Decompiled with CFR 0.152.
 */
package LBJ2.classify;

import LBJ2.classify.DiscreteFeature;
import LBJ2.classify.DiscretePrimitiveStringFeature;
import LBJ2.classify.Feature;
import LBJ2.classify.RealFeature;
import LBJ2.classify.RealPrimitiveFeature;
import LBJ2.learn.Lexicon;
import LBJ2.util.ByteString;
import LBJ2.util.ExceptionlessInputStream;
import LBJ2.util.ExceptionlessOutputStream;

public class DiscretePrimitiveFeature
extends DiscreteFeature {
    protected ByteString identifier;
    protected ByteString value;

    protected DiscretePrimitiveFeature() {
    }

    public DiscretePrimitiveFeature(String string, String string2, ByteString byteString, ByteString byteString2) {
        this(string, string2, byteString, byteString2, -1, 0);
    }

    public DiscretePrimitiveFeature(String string, String string2, ByteString byteString, ByteString byteString2, short s, short s2) {
        super(string, string2, s, s2);
        this.identifier = byteString;
        this.value = byteString2;
    }

    public boolean hasByteStringIdentifier() {
        return true;
    }

    public boolean isPrimitive() {
        return true;
    }

    public String getStringIdentifier() {
        return this.identifier.toString();
    }

    public ByteString getByteStringIdentifier() {
        return (ByteString)this.identifier.clone();
    }

    public String getStringValue() {
        return this.value.toString();
    }

    public ByteString getByteStringValue() {
        return (ByteString)this.value.clone();
    }

    public boolean valueEquals(String string) {
        return this.value.equals(string);
    }

    public Feature getFeatureKey(Lexicon lexicon, boolean bl, int n) {
        if (this.totalValues() == 2) {
            return new DiscretePrimitiveFeature(this.containingPackage, this.generatingClassifier, this.identifier, ByteString.emptyString, -1, 2);
        }
        return this;
    }

    public RealFeature makeReal() {
        if (this.totalValues == 2) {
            return new RealPrimitiveFeature(this.containingPackage, this.generatingClassifier, this.identifier, this.valueIndex);
        }
        ByteString byteString = (ByteString)this.identifier.clone();
        ByteString[] byteStringArray = new ByteString[]{new ByteString("_", byteString.getEncoding()), this.value};
        byteString.append(byteStringArray);
        return new RealPrimitiveFeature(this.containingPackage, this.generatingClassifier, byteString, 1.0);
    }

    public Feature withStrength(double d) {
        if (this.totalValues != 2 || d != 0.0 && d != 1.0) {
            return null;
        }
        return new DiscretePrimitiveFeature(this.containingPackage, this.generatingClassifier, this.identifier, ByteString.emptyString, (short)Math.round(d), 2);
    }

    public Feature encode(String string) {
        return this;
    }

    public int hashCode() {
        return 31 * super.hashCode() + 17 * this.identifier.hashCode() + this.value.hashCode();
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof DiscretePrimitiveFeature) {
            DiscretePrimitiveFeature discretePrimitiveFeature = (DiscretePrimitiveFeature)object;
            return this.identifier.equals(discretePrimitiveFeature.identifier) && this.valueIndex > -1 ? this.valueIndex == discretePrimitiveFeature.valueIndex : this.value.equals(discretePrimitiveFeature.value);
        }
        DiscretePrimitiveStringFeature discretePrimitiveStringFeature = (DiscretePrimitiveStringFeature)object;
        return this.identifier.equals(discretePrimitiveStringFeature.identifier) && this.valueIndex > -1 ? this.valueIndex == discretePrimitiveStringFeature.valueIndex : this.value.equals(discretePrimitiveStringFeature.value);
    }

    public boolean classEquivalent(Feature feature) {
        return feature instanceof DiscretePrimitiveStringFeature;
    }

    public int compareTo(Object object) {
        int n = this.compareNameStrings(object);
        if (n != 0) {
            return n;
        }
        DiscretePrimitiveFeature discretePrimitiveFeature = (DiscretePrimitiveFeature)object;
        n = this.identifier.compareTo(discretePrimitiveFeature.identifier);
        if (n != 0) {
            return n;
        }
        return this.value.compareTo(discretePrimitiveFeature.value);
    }

    public void write(StringBuffer stringBuffer) {
        this.writeNameString(stringBuffer);
        stringBuffer.append("(");
        stringBuffer.append(this.value.toString());
        stringBuffer.append(")");
    }

    public void writeNameString(StringBuffer stringBuffer) {
        super.writeNameString(stringBuffer);
        stringBuffer.append(":");
        stringBuffer.append(this.identifier.toString());
    }

    public void write(ExceptionlessOutputStream exceptionlessOutputStream) {
        super.write(exceptionlessOutputStream);
        this.identifier.write(exceptionlessOutputStream);
        this.value.write(exceptionlessOutputStream);
    }

    public void read(ExceptionlessInputStream exceptionlessInputStream) {
        super.read(exceptionlessInputStream);
        this.identifier = ByteString.readByteString(exceptionlessInputStream);
        this.value = ByteString.readByteString(exceptionlessInputStream);
    }

    public String lexWrite(ExceptionlessOutputStream exceptionlessOutputStream, Lexicon lexicon, String string, String string2, String string3, String string4, ByteString byteString) {
        String string5 = super.lexWrite(exceptionlessOutputStream, lexicon, string, string2, string3, string4, byteString);
        this.identifier.lexWrite(exceptionlessOutputStream, byteString);
        this.value.lexWrite(exceptionlessOutputStream, this.identifier);
        return string5;
    }

    public void lexRead(ExceptionlessInputStream exceptionlessInputStream, Lexicon lexicon, String string, String string2, String string3, ByteString byteString) {
        super.lexRead(exceptionlessInputStream, lexicon, string, string2, string3, byteString);
        this.identifier = ByteString.lexReadByteString(exceptionlessInputStream, byteString);
        this.value = ByteString.lexReadByteString(exceptionlessInputStream, this.identifier);
    }
}

